/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class RouterFunctionData {
    private String path;
    private List<String> consumes = new ArrayList<String>();
    private List<String> produces = new ArrayList<String>();
    private List<String> headers = new ArrayList<String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private RequestMethod[] methods;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void addQueryParams(String name, String value) {
        this.queryParams.put(name, value);
    }

    public String[] getHeaders() {
        return this.headers.toArray(new String[this.headers.size()]);
    }

    public void addHeaders(String headers) {
        if (StringUtils.isNotBlank((CharSequence)headers)) {
            this.headers.add(headers);
        }
    }

    public RequestMethod[] getMethods() {
        return this.methods;
    }

    public void setMethods(Set<HttpMethod> methods) {
        this.methods = this.getMethod(methods);
    }

    public String[] getConsumes() {
        return this.consumes.toArray(new String[this.consumes.size()]);
    }

    public void addConsumes(String consumes) {
        if (StringUtils.isNotBlank((CharSequence)consumes)) {
            this.consumes.add(consumes);
        }
    }

    public void addProduces(String produces) {
        if (StringUtils.isNotBlank((CharSequence)produces)) {
            this.produces.add(produces);
        }
    }

    private RequestMethod[] getMethod(Set<HttpMethod> methods) {
        if (!CollectionUtils.isEmpty(methods)) {
            return (RequestMethod[])methods.stream().map(this::getRequestMethod).toArray(RequestMethod[]::new);
        }
        return (RequestMethod[])ArrayUtils.toArray((Object[])new RequestMethod[0]);
    }

    public String[] getProduces() {
        return this.produces.toArray(new String[this.produces.size()]);
    }

    private RequestMethod getRequestMethod(HttpMethod httpMethod) {
        RequestMethod requestMethod = null;
        switch (httpMethod) {
            case GET: {
                requestMethod = RequestMethod.GET;
                break;
            }
            case POST: {
                requestMethod = RequestMethod.POST;
                break;
            }
            case PUT: {
                requestMethod = RequestMethod.PUT;
                break;
            }
            case DELETE: {
                requestMethod = RequestMethod.DELETE;
                break;
            }
            case PATCH: {
                requestMethod = RequestMethod.PATCH;
                break;
            }
            case HEAD: {
                requestMethod = RequestMethod.HEAD;
                break;
            }
            case OPTIONS: {
                requestMethod = RequestMethod.OPTIONS;
                break;
            }
        }
        return requestMethod;
    }
}

