/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.DelegatingMethodParameter;
import org.springdoc.core.GenericParameterBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.RequestBodyBuilder;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.RequestInfo;
import org.springdoc.core.converters.SchemaPropertyDeprecatingConverter;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpMethod;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractRequestBuilder {
    private static final List<Class> PARAM_TYPES_TO_IGNORE = new ArrayList<Class>();
    private static final String[] ANNOTATIONS_FOR_REQUIRED = new String[]{NotNull.class.getName(), "javax.validation.constraints.NotBlank", "javax.validation.constraints.NotEmpty"};
    private static final String POSITIVE_OR_ZERO = "javax.validation.constraints.PositiveOrZero";
    private static final String NEGATIVE_OR_ZERO = "javax.validation.constraints.NegativeOrZero";
    private final GenericParameterBuilder parameterBuilder;
    private final RequestBodyBuilder requestBodyBuilder;
    private final OperationBuilder operationBuilder;
    private final LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer;
    private final Optional<List<ParameterCustomizer>> parameterCustomizers;

    protected AbstractRequestBuilder(GenericParameterBuilder parameterBuilder, RequestBodyBuilder requestBodyBuilder, OperationBuilder operationBuilder, Optional<List<ParameterCustomizer>> parameterCustomizers, LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyBuilder = requestBodyBuilder;
        this.operationBuilder = operationBuilder;
        if (parameterCustomizers.isPresent()) {
            parameterCustomizers.get().removeIf(Objects::isNull);
        }
        this.parameterCustomizers = parameterCustomizers;
        this.localSpringDocParameterNameDiscoverer = localSpringDocParameterNameDiscoverer;
    }

    public static void addRequestWrapperToIgnore(Class<?> ... classes) {
        PARAM_TYPES_TO_IGNORE.addAll(Arrays.asList(classes));
    }

    public static void removeRequestWrapperToIgnore(Class<?> ... classes) {
        List<Class<?>> classesToIgnore = Arrays.asList(classes);
        if (PARAM_TYPES_TO_IGNORE.containsAll(classesToIgnore)) {
            PARAM_TYPES_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    public static boolean isRequestTypeToIgnore(Class<?> rawClass) {
        return PARAM_TYPES_TO_IGNORE.stream().anyMatch(clazz -> clazz.isAssignableFrom(rawClass));
    }

    public Operation build(HandlerMethod handlerMethod, RequestMethod requestMethod, Operation operation, MethodAttributes methodAttributes, OpenAPI openAPI) {
        String operationId = this.operationBuilder.getOperationId(handlerMethod.getMethod().getName(), operation.getOperationId(), openAPI);
        operation.setOperationId(operationId);
        String[] pNames = this.localSpringDocParameterNameDiscoverer.getParameterNames(handlerMethod.getMethod());
        MethodParameter[] parameters = handlerMethod.getMethodParameters();
        String[] reflectionParametersNames = (String[])Arrays.stream(handlerMethod.getMethod().getParameters()).map(Parameter::getName).toArray(String[]::new);
        if (pNames == null || Arrays.stream(pNames).anyMatch(Objects::isNull)) {
            pNames = reflectionParametersNames;
        }
        parameters = DelegatingMethodParameter.customize(pNames, parameters);
        RequestBodyInfo requestBodyInfo = new RequestBodyInfo();
        List operationParameters = operation.getParameters() != null ? operation.getParameters() : new ArrayList();
        Map<String, io.swagger.v3.oas.annotations.Parameter> parametersDocMap = this.getApiParameters(handlerMethod.getMethod());
        Components components = openAPI.getComponents();
        for (MethodParameter methodParameter : parameters) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = null;
            io.swagger.v3.oas.annotations.Parameter parameterDoc = (io.swagger.v3.oas.annotations.Parameter)methodParameter.getParameterAnnotation(io.swagger.v3.oas.annotations.Parameter.class);
            String pName = methodParameter.getParameterName();
            ParameterInfo parameterInfo = new ParameterInfo(pName, methodParameter);
            if (parameterDoc == null) {
                parameterDoc = parametersDocMap.get(parameterInfo.getpName());
            }
            if (parameterDoc != null) {
                if (parameterDoc.hidden() || parameterDoc.schema().hidden()) continue;
                parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, methodAttributes.getJsonViewAnnotation());
                parameterInfo.setParameterModel(parameter);
            }
            if (this.isParamToIgnore(methodParameter)) continue;
            parameter = this.buildParams(parameterInfo, components, requestMethod, methodAttributes.getJsonViewAnnotation());
            parameter = this.parameterBuilder.mergeParameter(operationParameters, parameter);
            List<Annotation> parameterAnnotations = Arrays.asList(methodParameter.getParameterAnnotations());
            if (this.isValidParameter(parameter)) {
                this.applyBeanValidatorAnnotations(parameter, parameterAnnotations);
            } else if (!RequestMethod.GET.equals((Object)requestMethod)) {
                if (operation.getRequestBody() != null) {
                    requestBodyInfo.setRequestBody(operation.getRequestBody());
                }
                this.requestBodyBuilder.calculateRequestBodyInfo(components, methodAttributes, parameterInfo, requestBodyInfo);
                this.applyBeanValidatorAnnotations(requestBodyInfo.getRequestBody(), parameterAnnotations, methodParameter.isOptional());
            }
            this.customiseParameter(parameter, parameterInfo);
        }
        LinkedHashMap<String, io.swagger.v3.oas.models.parameters.Parameter> map = this.getParameterLinkedHashMap(components, methodAttributes, operationParameters, parametersDocMap);
        this.setParams(operation, new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(map.values()), requestBodyInfo);
        return operation;
    }

    private LinkedHashMap<String, io.swagger.v3.oas.models.parameters.Parameter> getParameterLinkedHashMap(Components components, MethodAttributes methodAttributes, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, Map<String, io.swagger.v3.oas.annotations.Parameter> parametersDocMap) {
        LinkedHashMap map = operationParameters.stream().collect(Collectors.toMap(parameter -> parameter.getName() != null ? parameter.getName() : Integer.toString(parameter.hashCode()), parameter -> parameter, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        for (Map.Entry<String, io.swagger.v3.oas.annotations.Parameter> entry : parametersDocMap.entrySet()) {
            if (entry.getKey() == null || map.containsKey(entry.getKey()) || entry.getValue().hidden()) continue;
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = this.parameterBuilder.buildParameterFromDoc(entry.getValue(), components, methodAttributes.getJsonViewAnnotation());
            map.put(entry.getKey(), parameter2);
        }
        for (Map.Entry<String, Object> entry : methodAttributes.getHeaders().entrySet()) {
            io.swagger.v3.oas.models.parameters.Parameter parameter2 = new io.swagger.v3.oas.models.parameters.Parameter().in(ParameterIn.HEADER.toString()).name(entry.getKey()).schema((Schema)new StringSchema().addEnumItem((String)entry.getValue()));
            if (map.containsKey(entry.getKey())) {
                parameter2 = (io.swagger.v3.oas.models.parameters.Parameter)map.get(entry.getKey());
                parameter2.getSchema().addEnumItemObject(entry.getValue());
                parameter2.setSchema(parameter2.getSchema());
            }
            map.put(entry.getKey(), parameter2);
        }
        return map;
    }

    protected io.swagger.v3.oas.models.parameters.Parameter customiseParameter(io.swagger.v3.oas.models.parameters.Parameter parameter, ParameterInfo parameterInfo) {
        this.parameterCustomizers.ifPresent(customizers -> customizers.forEach(customizer -> customizer.customize(parameter, parameterInfo.getMethodParameter())));
        return parameter;
    }

    protected boolean isParamToIgnore(MethodParameter parameter) {
        if (this.parameterBuilder.isAnnotationToIgnore(parameter)) {
            return true;
        }
        if (parameter.getParameterAnnotation(PathVariable.class) != null && ((PathVariable)parameter.getParameterAnnotation(PathVariable.class)).required() || parameter.getParameterAnnotation(RequestParam.class) != null && ((RequestParam)parameter.getParameterAnnotation(RequestParam.class)).required() || parameter.getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class) != null && ((org.springframework.web.bind.annotation.RequestBody)parameter.getParameterAnnotation(org.springframework.web.bind.annotation.RequestBody.class)).required()) {
            return false;
        }
        return AbstractRequestBuilder.isRequestTypeToIgnore(parameter.getParameterType());
    }

    private void setParams(Operation operation, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, RequestBodyInfo requestBodyInfo) {
        if (!CollectionUtils.isEmpty(operationParameters)) {
            operation.setParameters(operationParameters);
        }
        if (requestBodyInfo.getRequestBody() != null) {
            operation.setRequestBody(requestBodyInfo.getRequestBody());
        }
    }

    private boolean isValidParameter(io.swagger.v3.oas.models.parameters.Parameter parameter) {
        return parameter != null && (parameter.getName() != null || parameter.get$ref() != null);
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParams(ParameterInfo parameterInfo, Components components, RequestMethod requestMethod, JsonView jsonView) {
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        RequestHeader requestHeader = parameterInfo.getRequestHeader();
        RequestParam requestParam = parameterInfo.getRequestParam();
        PathVariable pathVar = parameterInfo.getPathVar();
        CookieValue cookieValue = parameterInfo.getCookieValue();
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        if (requestHeader != null) {
            RequestInfo requestInfo = new RequestInfo(ParameterIn.HEADER.toString(), parameterInfo.getpName(), requestHeader.required(), requestHeader.defaultValue());
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        } else if (requestParam != null && !this.parameterBuilder.isFile(parameterInfo.getMethodParameter())) {
            RequestInfo requestInfo = new RequestInfo(ParameterIn.QUERY.toString(), parameterInfo.getpName(), requestParam.required() && !methodParameter.isOptional(), requestParam.defaultValue());
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        } else if (pathVar != null) {
            RequestInfo requestInfo = new RequestInfo(ParameterIn.PATH.toString(), parameterInfo.getpName(), !methodParameter.isOptional(), null);
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        } else if (cookieValue != null) {
            RequestInfo requestInfo = new RequestInfo(ParameterIn.COOKIE.toString(), parameterInfo.getpName(), cookieValue.required(), cookieValue.defaultValue());
            parameter = this.buildParam(parameterInfo, components, requestInfo, jsonView);
        }
        if (RequestMethod.GET.equals((Object)requestMethod) || parameterInfo.getParameterModel() != null && ParameterIn.PATH.toString().equals(parameterInfo.getParameterModel().getIn())) {
            parameter = this.buildParam("query", components, parameterInfo, !methodParameter.isOptional(), null, jsonView);
        }
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(ParameterInfo parameterInfo, Components components, RequestInfo requestInfo, JsonView jsonView) {
        String pName = parameterInfo.getpName();
        String name = StringUtils.isBlank((CharSequence)requestInfo.value()) ? pName : requestInfo.value();
        parameterInfo.setpName(name);
        io.swagger.v3.oas.models.parameters.Parameter parameter = !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestInfo.defaultValue()) ? this.buildParam(requestInfo.type(), components, parameterInfo, false, requestInfo.defaultValue(), jsonView) : this.buildParam(requestInfo.type(), components, parameterInfo, requestInfo.required(), null, jsonView);
        return parameter;
    }

    private io.swagger.v3.oas.models.parameters.Parameter buildParam(String in, Components components, ParameterInfo parameterInfo, Boolean required, String defaultValue, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = parameterInfo.getParameterModel();
        String name = parameterInfo.getpName();
        if (parameter == null) {
            parameter = new io.swagger.v3.oas.models.parameters.Parameter();
            parameterInfo.setParameterModel(parameter);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getName())) {
            parameter.setName(name);
        }
        if (StringUtils.isBlank((CharSequence)parameter.getIn())) {
            parameter.setIn(in);
        }
        if (required != null && parameter.getRequired() == null) {
            parameter.setRequired(required);
        }
        if (SchemaPropertyDeprecatingConverter.containsDeprecatedAnnotation(parameterInfo.getMethodParameter().getParameterAnnotations())) {
            parameter.setDeprecated(Boolean.valueOf(true));
        }
        if (parameter.getSchema() == null) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo, null, jsonView);
            if (defaultValue != null) {
                schema.setDefault((Object)defaultValue);
            }
            parameter.setSchema(schema);
        }
        return parameter;
    }

    private void applyBeanValidatorAnnotations(io.swagger.v3.oas.models.parameters.Parameter parameter, List<Annotation> annotations) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), (Annotation)annotation));
        }
        boolean annotationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (annotationExists) {
            parameter.setRequired(Boolean.valueOf(true));
        }
        Schema schema = parameter.getSchema();
        this.applyValidationsToSchema(annos, schema);
    }

    private void applyBeanValidatorAnnotations(RequestBody requestBody, List<Annotation> annotations, boolean isOptional) {
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        boolean requestBodyRequired = false;
        if (!CollectionUtils.isEmpty(annotations)) {
            annotations.forEach(annotation -> annos.put(annotation.annotationType().getName(), (Annotation)annotation));
            requestBodyRequired = annotations.stream().filter(annotation -> org.springframework.web.bind.annotation.RequestBody.class.equals(annotation.annotationType())).anyMatch(annotation -> ((org.springframework.web.bind.annotation.RequestBody)annotation).required());
        }
        boolean validationExists = Arrays.stream(ANNOTATIONS_FOR_REQUIRED).anyMatch(annos::containsKey);
        if (validationExists || !isOptional && requestBodyRequired) {
            requestBody.setRequired(Boolean.valueOf(true));
        }
        Content content = requestBody.getContent();
        for (MediaType mediaType : content.values()) {
            Schema schema = mediaType.getSchema();
            this.applyValidationsToSchema(annos, schema);
        }
    }

    private void calculateSize(Map<String, Annotation> annos, Schema<?> schema) {
        if (annos.containsKey(Size.class.getName())) {
            Size size = (Size)annos.get(Size.class.getName());
            if ("array".equals(schema.getType())) {
                schema.setMinItems(Integer.valueOf(size.min()));
                schema.setMaxItems(Integer.valueOf(size.max()));
            } else if ("string".equals(schema.getType())) {
                schema.setMinLength(Integer.valueOf(size.min()));
                schema.setMaxLength(Integer.valueOf(size.max()));
            }
        }
    }

    public RequestBodyBuilder getRequestBodyBuilder() {
        return this.requestBodyBuilder;
    }

    private Map<String, io.swagger.v3.oas.annotations.Parameter> getApiParameters(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiParametersDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, Parameters.class);
        LinkedHashMap apiParametersMap = apiParametersDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        Set apiParametersDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, Parameters.class);
        LinkedHashMap apiParametersDocDeclaringClassMap = apiParametersDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParametersDocDeclaringClassMap);
        Set apiParameterDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocMap = apiParameterDoc.stream().collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocMap);
        Set apiParameterDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, io.swagger.v3.oas.annotations.Parameter.class);
        LinkedHashMap apiParameterDocDeclaringClassMap = apiParameterDocDeclaringClass.stream().collect(Collectors.toMap(io.swagger.v3.oas.annotations.Parameter::name, x -> x, (e1, e2) -> e2, LinkedHashMap::new));
        apiParametersMap.putAll(apiParameterDocDeclaringClassMap);
        return apiParametersMap;
    }

    private void applyValidationsToSchema(Map<String, Annotation> annos, Schema<?> schema) {
        Max max;
        Min min;
        if (annos.containsKey(Min.class.getName())) {
            min = (Min)annos.get(Min.class.getName());
            schema.setMinimum(BigDecimal.valueOf(min.value()));
        }
        if (annos.containsKey(Max.class.getName())) {
            max = (Max)annos.get(Max.class.getName());
            schema.setMaximum(BigDecimal.valueOf(max.value()));
        }
        this.calculateSize(annos, schema);
        if (annos.containsKey(DecimalMin.class.getName())) {
            min = (DecimalMin)annos.get(DecimalMin.class.getName());
            if (min.inclusive()) {
                schema.setMinimum(BigDecimal.valueOf(Double.parseDouble(min.value())));
            } else {
                schema.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey(DecimalMax.class.getName())) {
            max = (DecimalMax)annos.get(DecimalMax.class.getName());
            if (max.inclusive()) {
                schema.setMaximum(BigDecimal.valueOf(Double.parseDouble(max.value())));
            } else {
                schema.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey(POSITIVE_OR_ZERO)) {
            schema.setMinimum(BigDecimal.ZERO);
        }
        if (annos.containsKey(NEGATIVE_OR_ZERO)) {
            schema.setMaximum(BigDecimal.ZERO);
        }
        if (annos.containsKey(Pattern.class.getName())) {
            Pattern pattern = (Pattern)annos.get(Pattern.class.getName());
            schema.setPattern(pattern.regexp());
        }
    }

    static {
        PARAM_TYPES_TO_IGNORE.add(WebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(NativeWebRequest.class);
        PARAM_TYPES_TO_IGNORE.add(Principal.class);
        PARAM_TYPES_TO_IGNORE.add(HttpMethod.class);
        PARAM_TYPES_TO_IGNORE.add(Locale.class);
        PARAM_TYPES_TO_IGNORE.add(TimeZone.class);
        PARAM_TYPES_TO_IGNORE.add(InputStream.class);
        PARAM_TYPES_TO_IGNORE.add(ZoneId.class);
        PARAM_TYPES_TO_IGNORE.add(Reader.class);
        PARAM_TYPES_TO_IGNORE.add(OutputStream.class);
        PARAM_TYPES_TO_IGNORE.add(Writer.class);
        PARAM_TYPES_TO_IGNORE.add(Map.class);
        PARAM_TYPES_TO_IGNORE.add(Model.class);
        PARAM_TYPES_TO_IGNORE.add(ModelMap.class);
        PARAM_TYPES_TO_IGNORE.add(Errors.class);
        PARAM_TYPES_TO_IGNORE.add(BindingResult.class);
        PARAM_TYPES_TO_IGNORE.add(SessionStatus.class);
        PARAM_TYPES_TO_IGNORE.add(UriComponentsBuilder.class);
        PARAM_TYPES_TO_IGNORE.add(RequestAttribute.class);
    }
}

