/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.SecurityParser;
import org.springdoc.core.SecuritySchemePair;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiBuilderCustomiser;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;

public class OpenAPIBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIBuilder.class);
    private final ApplicationContext context;
    private final SecurityParser securityParser;
    private final Map<String, Object> mappingsMap = new HashMap<String, Object>();
    private final Map<HandlerMethod, io.swagger.v3.oas.models.tags.Tag> springdocTags = new HashMap<HandlerMethod, io.swagger.v3.oas.models.tags.Tag>();
    private final Optional<List<OpenApiBuilderCustomiser>> openApiBuilderCustomisers;
    private final SpringDocConfigProperties springDocConfigProperties;
    private OpenAPI openAPI;
    private OpenAPI cachedOpenAPI;
    private OpenAPI calculatedOpenAPI;
    private boolean isServersPresent;
    private String serverBaseUrl;

    OpenAPIBuilder(Optional<OpenAPI> openAPI, ApplicationContext context, SecurityParser securityParser, SpringDocConfigProperties springDocConfigProperties, Optional<List<OpenApiBuilderCustomiser>> openApiBuilderCustomisers) {
        if (openAPI.isPresent()) {
            this.openAPI = openAPI.get();
            if (this.openAPI.getComponents() == null) {
                this.openAPI.setComponents(new Components());
            }
            if (this.openAPI.getPaths() == null) {
                this.openAPI.setPaths(new Paths());
            }
            if (!CollectionUtils.isEmpty((Collection)this.openAPI.getServers())) {
                this.isServersPresent = true;
            }
        }
        this.context = context;
        this.securityParser = securityParser;
        this.springDocConfigProperties = springDocConfigProperties;
        this.openApiBuilderCustomisers = openApiBuilderCustomisers;
    }

    public static String splitCamelCase(String str) {
        return str.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "-").toLowerCase(Locale.ROOT);
    }

    public void build() {
        Optional<OpenAPIDefinition> apiDef = this.getOpenAPIDefinition();
        if (this.openAPI == null) {
            this.calculatedOpenAPI = new OpenAPI();
            this.calculatedOpenAPI.setComponents(new Components());
            this.calculatedOpenAPI.setPaths(new Paths());
        } else {
            this.calculatedOpenAPI = this.openAPI;
        }
        if (apiDef.isPresent()) {
            this.buildOpenAPIWithOpenAPIDefinition(this.calculatedOpenAPI, apiDef.get());
        } else if (this.calculatedOpenAPI.getInfo() == null) {
            io.swagger.v3.oas.models.info.Info infos = new io.swagger.v3.oas.models.info.Info().title("OpenAPI definition").version("v0");
            this.calculatedOpenAPI.setInfo(infos);
        }
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(RestController.class));
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(RequestMapping.class));
        this.mappingsMap.putAll(this.context.getBeansWithAnnotation(Controller.class));
        if (CollectionUtils.isEmpty((Collection)this.calculatedOpenAPI.getServers()) || !this.isServersPresent) {
            this.updateServers(this.calculatedOpenAPI);
        }
        this.calculateSecuritySchemes(this.calculatedOpenAPI.getComponents());
        this.openApiBuilderCustomisers.ifPresent(customisers -> customisers.forEach(customiser -> customiser.customise(this)));
    }

    public void updateServers(OpenAPI openAPI) {
        io.swagger.v3.oas.models.servers.Server server = new io.swagger.v3.oas.models.servers.Server().url(this.serverBaseUrl).description("Generated server url");
        ArrayList<io.swagger.v3.oas.models.servers.Server> servers = new ArrayList<io.swagger.v3.oas.models.servers.Server>();
        servers.add(server);
        openAPI.setServers(servers);
    }

    public boolean isServersPresent() {
        return this.isServersPresent;
    }

    public Operation buildTags(HandlerMethod handlerMethod, Operation operation, OpenAPI openAPI) {
        SecurityRequirement[] securityRequirements;
        Optional tags;
        Set tagsSet = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)handlerMethod.getBeanType(), Tags.class);
        Set classTags = tagsSet.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet());
        classTags.addAll(AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)handlerMethod.getBeanType(), Tag.class));
        tagsSet = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)handlerMethod.getMethod(), Tags.class);
        Set methodTags = tagsSet.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet());
        methodTags.addAll(AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)handlerMethod.getMethod(), Tag.class));
        ArrayList allTags = new ArrayList();
        HashSet<String> tagsStr = new HashSet<String>();
        if (!CollectionUtils.isEmpty(methodTags)) {
            tagsStr.addAll(methodTags.stream().map(Tag::name).collect(Collectors.toSet()));
            allTags.addAll(methodTags);
        }
        if (!CollectionUtils.isEmpty(classTags)) {
            tagsStr.addAll(classTags.stream().map(Tag::name).collect(Collectors.toSet()));
            allTags.addAll(classTags);
        }
        if (this.springdocTags.containsKey(handlerMethod)) {
            io.swagger.v3.oas.models.tags.Tag tag = this.springdocTags.get(handlerMethod);
            tagsStr.add(tag.getName());
            if (openAPI.getTags() == null || !openAPI.getTags().contains(tag)) {
                openAPI.addTagsItem(tag);
            }
        }
        if ((tags = AnnotationsUtils.getTags((Tag[])allTags.toArray(new Tag[0]), (boolean)true)).isPresent()) {
            Set tagSet = (Set)tags.get();
            List openApiTags = openAPI.getTags();
            if (!CollectionUtils.isEmpty((Collection)openApiTags)) {
                tagSet.addAll(openApiTags);
            }
            openAPI.setTags(new ArrayList(tagSet));
        }
        if ((securityRequirements = this.securityParser.getSecurityRequirements(handlerMethod)) != null) {
            if (securityRequirements.length == 0) {
                operation.setSecurity(Collections.emptyList());
            } else {
                this.securityParser.buildSecurityRequirement(securityRequirements, operation);
            }
        }
        if (!CollectionUtils.isEmpty(tagsStr)) {
            operation.setTags(new ArrayList(tagsStr));
        }
        if (this.isAutoTagClasses(operation)) {
            operation.addTagsItem(OpenAPIBuilder.splitCamelCase(handlerMethod.getBeanType().getSimpleName()));
        }
        return operation;
    }

    public Schema resolveProperties(Schema schema, PropertyResolverUtils propertyResolverUtils) {
        this.resolveProperty(() -> ((Schema)schema).getName(), arg_0 -> ((Schema)schema).name(arg_0), propertyResolverUtils);
        this.resolveProperty(() -> ((Schema)schema).getTitle(), arg_0 -> ((Schema)schema).title(arg_0), propertyResolverUtils);
        this.resolveProperty(() -> ((Schema)schema).getDescription(), arg_0 -> ((Schema)schema).description(arg_0), propertyResolverUtils);
        Map properties = schema.getProperties();
        if (!CollectionUtils.isEmpty((Map)properties)) {
            Map<String, Schema> resolvedSchemas = properties.entrySet().stream().map(es -> {
                es.setValue(this.resolveProperties((Schema)es.getValue(), propertyResolverUtils));
                return es;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            schema.setProperties(resolvedSchemas);
        }
        return schema;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    private Optional<OpenAPIDefinition> getOpenAPIDefinition() {
        Map openAPIDefinitionMap = this.context.getBeansWithAnnotation(OpenAPIDefinition.class);
        OpenAPIDefinition apiDef = null;
        if (openAPIDefinitionMap.size() > 1) {
            LOGGER.warn("found more than one OpenAPIDefinition class. springdoc-openapi will be using the first one found.");
        }
        if (openAPIDefinitionMap.size() > 0) {
            Map.Entry entry = openAPIDefinitionMap.entrySet().iterator().next();
            Class<?> objClz = entry.getValue().getClass();
            apiDef = (OpenAPIDefinition)AnnotatedElementUtils.findMergedAnnotation(objClz, OpenAPIDefinition.class);
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(OpenAPIDefinition.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                apiDef = this.getApiDefClass(scanner, packagesToScan);
            }
        }
        return Optional.ofNullable(apiDef);
    }

    private void buildOpenAPIWithOpenAPIDefinition(OpenAPI openAPI, OpenAPIDefinition apiDef) {
        AnnotationsUtils.getInfo((Info)apiDef.info()).map(this::resolveProperties).ifPresent(arg_0 -> ((OpenAPI)openAPI).setInfo(arg_0));
        this.securityParser.getSecurityRequirements(apiDef.security()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setSecurity(arg_0));
        AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiDef.externalDocs()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setExternalDocs(arg_0));
        AnnotationsUtils.getTags((Tag[])apiDef.tags(), (boolean)false).ifPresent(tags -> openAPI.setTags(new ArrayList(tags)));
        Optional optionalServers = AnnotationsUtils.getServers((Server[])apiDef.servers());
        if (optionalServers.isPresent()) {
            openAPI.setServers((List)optionalServers.get());
            this.isServersPresent = true;
        }
        if (apiDef.extensions().length > 0) {
            openAPI.setExtensions(AnnotationsUtils.getExtensions((Extension[])apiDef.extensions()));
        }
    }

    private io.swagger.v3.oas.models.info.Info resolveProperties(io.swagger.v3.oas.models.info.Info info) {
        Contact contact;
        PropertyResolverUtils propertyResolverUtils = (PropertyResolverUtils)this.context.getBean(PropertyResolverUtils.class);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getTitle(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).title(arg_0), propertyResolverUtils);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getDescription(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).description(arg_0), propertyResolverUtils);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getVersion(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).version(arg_0), propertyResolverUtils);
        this.resolveProperty(() -> ((io.swagger.v3.oas.models.info.Info)info).getTermsOfService(), arg_0 -> ((io.swagger.v3.oas.models.info.Info)info).termsOfService(arg_0), propertyResolverUtils);
        License license = info.getLicense();
        if (license != null) {
            this.resolveProperty(() -> ((License)license).getName(), arg_0 -> ((License)license).name(arg_0), propertyResolverUtils);
            this.resolveProperty(() -> ((License)license).getUrl(), arg_0 -> ((License)license).url(arg_0), propertyResolverUtils);
        }
        if ((contact = info.getContact()) != null) {
            this.resolveProperty(() -> ((Contact)contact).getName(), arg_0 -> ((Contact)contact).name(arg_0), propertyResolverUtils);
            this.resolveProperty(() -> ((Contact)contact).getEmail(), arg_0 -> ((Contact)contact).email(arg_0), propertyResolverUtils);
            this.resolveProperty(() -> ((Contact)contact).getUrl(), arg_0 -> ((Contact)contact).url(arg_0), propertyResolverUtils);
        }
        return info;
    }

    private void resolveProperty(Supplier<String> getProperty, Consumer<String> setProperty, PropertyResolverUtils propertyResolverUtils) {
        String value = getProperty.get();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            setProperty.accept(propertyResolverUtils.resolve(value));
        }
    }

    private void calculateSecuritySchemes(Components components) {
        Map securitySchemeBeans = this.context.getBeansWithAnnotation(SecurityScheme.class);
        if (securitySchemeBeans.size() > 0) {
            for (Map.Entry entry : securitySchemeBeans.entrySet()) {
                Class<?> objClz = entry.getValue().getClass();
                Set apiSecurityScheme = AnnotatedElementUtils.findMergedRepeatableAnnotations(objClz, SecurityScheme.class);
                this.addSecurityScheme(apiSecurityScheme, components);
            }
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SecurityScheme.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                Set<SecurityScheme> apiSecurityScheme = this.getSecuritySchemesClasses(scanner, packagesToScan);
                this.addSecurityScheme(apiSecurityScheme, components);
            }
        }
    }

    private void addSecurityScheme(Set<SecurityScheme> apiSecurityScheme, Components components) {
        for (SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
            Optional<SecuritySchemePair> securityScheme = this.securityParser.getSecurityScheme(securitySchemeAnnotation);
            if (!securityScheme.isPresent()) continue;
            HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme>();
            if (!StringUtils.isNotBlank((CharSequence)securityScheme.get().getKey())) continue;
            securitySchemeMap.put(securityScheme.get().getKey(), securityScheme.get().getSecurityScheme());
            if (!CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
                components.getSecuritySchemes().putAll(securitySchemeMap);
                continue;
            }
            components.setSecuritySchemes(securitySchemeMap);
        }
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return (OpenAPIDefinition)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private boolean isAutoTagClasses(Operation operation) {
        return CollectionUtils.isEmpty((Collection)operation.getTags()) && this.springDocConfigProperties.isAutoTagClasses();
    }

    private Set<SecurityScheme> getSecuritySchemesClasses(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        HashSet<SecurityScheme> apiSecurityScheme = new HashSet<SecurityScheme>();
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    apiSecurityScheme.add((SecurityScheme)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), SecurityScheme.class));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return apiSecurityScheme;
    }

    public void addTag(Set<HandlerMethod> handlerMethods, io.swagger.v3.oas.models.tags.Tag tag) {
        handlerMethods.forEach(handlerMethod -> this.springdocTags.put((HandlerMethod)handlerMethod, tag));
    }

    public Map<String, Object> getMappingsMap() {
        return this.mappingsMap;
    }

    public void addMappings(Map<String, Object> mappings) {
        this.mappingsMap.putAll(mappings);
    }

    public Map<String, Object> getControllerAdviceMap() {
        Map controllerAdviceMap = this.context.getBeansWithAnnotation(ControllerAdvice.class);
        return Stream.of(controllerAdviceMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
    }

    public OpenAPI calculateCachedOpenAPI() {
        if (!this.isServersPresent()) {
            this.updateServers(this.cachedOpenAPI);
        }
        return this.cachedOpenAPI;
    }

    public void setCachedOpenAPI(OpenAPI cachedOpenAPI) {
        this.cachedOpenAPI = cachedOpenAPI;
    }

    public OpenAPI getCachedOpenAPI() {
        return this.cachedOpenAPI;
    }

    public OpenAPI getCalculatedOpenAPI() {
        return this.calculatedOpenAPI;
    }

    public void resetCalculatedOpenAPI() {
        this.calculatedOpenAPI = null;
    }
}

