/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.SecurityParser;
import org.springdoc.core.SecuritySchemePair;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;

@Component
public class OpenAPIBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIBuilder.class);
    private final OpenAPI openAPI;
    private final ApplicationContext context;
    private final SecurityParser securityParser;
    private String serverBaseUrl;
    private final Map<HandlerMethod, String> springdocTags = new HashMap<HandlerMethod, String>();

    OpenAPIBuilder(Optional<OpenAPI> openAPI, ApplicationContext context, SecurityParser securityParser) {
        if (openAPI.isPresent()) {
            this.openAPI = openAPI.get();
            if (this.openAPI.getComponents() == null) {
                this.openAPI.setComponents(new Components());
            }
            if (this.openAPI.getPaths() == null) {
                this.openAPI.setPaths(new Paths());
            }
        } else {
            this.openAPI = new OpenAPI();
            this.openAPI.setComponents(new Components());
            this.openAPI.setPaths(new Paths());
        }
        this.context = context;
        this.securityParser = securityParser;
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public Components getComponents() {
        return this.openAPI.getComponents();
    }

    public Paths getPaths() {
        return this.openAPI.getPaths();
    }

    public void build() {
        Optional<OpenAPIDefinition> apiDef = this.getOpenAPIDefinition();
        if (apiDef.isPresent()) {
            this.buildOpenAPIWithOpenAPIDefinition(this.openAPI, apiDef.get());
        } else if (this.openAPI.getInfo() == null) {
            io.swagger.v3.oas.models.info.Info infos = new io.swagger.v3.oas.models.info.Info().title("OpenAPI definition").version("v0");
            this.openAPI.setInfo(infos);
        }
        if (CollectionUtils.isEmpty((Collection)this.openAPI.getServers())) {
            io.swagger.v3.oas.models.servers.Server server = new io.swagger.v3.oas.models.servers.Server().url(this.serverBaseUrl).description("Generated server url");
            this.openAPI.addServersItem(server);
        }
        this.calculateSecuritySchemes(this.openAPI.getComponents());
    }

    public Operation buildTags(HandlerMethod handlerMethod, Operation operation, OpenAPI openAPI) {
        Optional tags;
        List classTags = ReflectionUtils.getRepeatableAnnotations((Class)handlerMethod.getBeanType(), Tag.class);
        List methodTags = ReflectionUtils.getRepeatableAnnotations((Method)handlerMethod.getMethod(), Tag.class);
        ArrayList allTags = new ArrayList();
        HashSet<String> tagsStr = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)methodTags)) {
            tagsStr.addAll(methodTags.stream().map(Tag::name).collect(Collectors.toSet()));
            allTags.addAll(methodTags);
        }
        if (!CollectionUtils.isEmpty((Collection)classTags)) {
            tagsStr.addAll(classTags.stream().map(Tag::name).collect(Collectors.toSet()));
            allTags.addAll(classTags);
        }
        if (this.springdocTags.containsKey(handlerMethod)) {
            tagsStr.add(this.springdocTags.get(handlerMethod));
        }
        if ((tags = AnnotationsUtils.getTags((Tag[])allTags.toArray(new Tag[0]), (boolean)true)).isPresent()) {
            Set tagsSet = (Set)tags.get();
            List openApiTags = openAPI.getTags();
            if (!CollectionUtils.isEmpty((Collection)openApiTags)) {
                tagsSet.addAll(openApiTags);
            }
            openAPI.setTags(new ArrayList(tagsSet));
        }
        Optional<SecurityRequirement[]> securityRequirement = this.securityParser.getSecurityRequirements(handlerMethod);
        securityRequirement.ifPresent(securityRequirements -> this.securityParser.buildSecurityRequirement((SecurityRequirement[])securityRequirements, operation));
        if (!CollectionUtils.isEmpty(tagsStr)) {
            operation.setTags(new ArrayList(tagsStr));
        }
        return operation;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    private Optional<OpenAPIDefinition> getOpenAPIDefinition() {
        Map openAPIDefinitionMap = this.context.getBeansWithAnnotation(OpenAPIDefinition.class);
        OpenAPIDefinition apiDef = null;
        if (openAPIDefinitionMap.size() > 1) {
            LOGGER.warn("found more than one OpenAPIDefinition class. springdoc-openapi will be using the first one found.");
        }
        if (openAPIDefinitionMap.size() > 0) {
            Map.Entry entry = openAPIDefinitionMap.entrySet().iterator().next();
            Class<?> objClz = entry.getValue().getClass();
            apiDef = (OpenAPIDefinition)ReflectionUtils.getAnnotation(objClz, OpenAPIDefinition.class);
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(OpenAPIDefinition.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                apiDef = this.getApiDefClass(scanner, packagesToScan);
            }
        }
        return Optional.ofNullable(apiDef);
    }

    private void buildOpenAPIWithOpenAPIDefinition(OpenAPI openAPI, OpenAPIDefinition apiDef) {
        AnnotationsUtils.getInfo((Info)apiDef.info()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setInfo(arg_0));
        this.securityParser.getSecurityRequirements(apiDef.security()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setSecurity(arg_0));
        AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)apiDef.externalDocs()).ifPresent(arg_0 -> ((OpenAPI)openAPI).setExternalDocs(arg_0));
        AnnotationsUtils.getTags((Tag[])apiDef.tags(), (boolean)false).ifPresent(tags -> openAPI.setTags(new ArrayList(tags)));
        openAPI.setServers((List)AnnotationsUtils.getServers((Server[])apiDef.servers()).orElse(null));
        if (apiDef.extensions().length > 0) {
            openAPI.setExtensions(AnnotationsUtils.getExtensions((Extension[])apiDef.extensions()));
        }
    }

    private void calculateSecuritySchemes(Components components) {
        Map securitySchemeBeans = this.context.getBeansWithAnnotation(SecurityScheme.class);
        if (securitySchemeBeans.size() > 0) {
            for (Map.Entry entry : securitySchemeBeans.entrySet()) {
                Class<?> objClz = entry.getValue().getClass();
                List apiSecurityScheme = ReflectionUtils.getRepeatableAnnotations(objClz, SecurityScheme.class);
                this.addSecurityScheme(apiSecurityScheme, components);
            }
        } else {
            ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SecurityScheme.class));
            if (AutoConfigurationPackages.has((BeanFactory)this.context)) {
                List packagesToScan = AutoConfigurationPackages.get((BeanFactory)this.context);
                List<SecurityScheme> apiSecurityScheme = this.getSecuritySchemesClasses(scanner, packagesToScan);
                this.addSecurityScheme(apiSecurityScheme, components);
            }
        }
    }

    private void addSecurityScheme(List<SecurityScheme> apiSecurityScheme, Components components) {
        for (SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
            Optional<SecuritySchemePair> securityScheme = this.securityParser.getSecurityScheme(securitySchemeAnnotation);
            if (!securityScheme.isPresent()) continue;
            HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme>();
            if (!StringUtils.isNotBlank((CharSequence)securityScheme.get().getKey())) continue;
            securitySchemeMap.put(securityScheme.get().getKey(), securityScheme.get().getSecurityScheme());
            if (!CollectionUtils.isEmpty((Map)components.getSecuritySchemes())) {
                components.getSecuritySchemes().putAll(securitySchemeMap);
                continue;
            }
            components.setSecuritySchemes(securitySchemeMap);
        }
    }

    private OpenAPIDefinition getApiDefClass(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    return (OpenAPIDefinition)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), OpenAPIDefinition.class);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private List<SecurityScheme> getSecuritySchemesClasses(ClassPathScanningCandidateComponentProvider scanner, List<String> packagesToScan) {
        ArrayList<SecurityScheme> apiSecurityScheme = new ArrayList<SecurityScheme>();
        for (String pack : packagesToScan) {
            for (BeanDefinition bd : scanner.findCandidateComponents(pack)) {
                try {
                    apiSecurityScheme.add((SecurityScheme)AnnotationUtils.findAnnotation(Class.forName(bd.getBeanClassName()), SecurityScheme.class));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Class Not Found in classpath : {}", (Object)e.getMessage());
                }
            }
        }
        return apiSecurityScheme;
    }

    public void addTag(Set<HandlerMethod> handlerMethods, String tagName) {
        handlerMethods.forEach(handlerMethod -> this.springdocTags.put((HandlerMethod)handlerMethod, tagName));
    }

    public Map<String, Object> getRestControllersMap() {
        return this.context.getBeansWithAnnotation(RestController.class);
    }

    public Map<String, Object> getRequestMappingMap() {
        return this.context.getBeansWithAnnotation(RequestMapping.class);
    }

    public Map<String, Object> getControllerAdviceMap() {
        Map controllerAdviceMap = this.context.getBeansWithAnnotation(ControllerAdvice.class);
        return Stream.of(controllerAdviceMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
    }
}

