/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.GeneralInfoBuilder;
import org.springdoc.core.MediaAttributes;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.TagsBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOpenApiResource {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenApiResource.class);
    protected OpenAPIBuilder openAPIBuilder;
    protected AbstractRequestBuilder requestBuilder;
    protected AbstractResponseBuilder responseBuilder;
    protected TagsBuilder tagbuiBuilder;
    protected OperationBuilder operationParser;
    protected GeneralInfoBuilder generalInfoBuilder;
    protected ApplicationContext context;

    protected AbstractOpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, TagsBuilder tagbuiBuilder, OperationBuilder operationParser, GeneralInfoBuilder infoBuilder) {
        this.openAPIBuilder = openAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.tagbuiBuilder = tagbuiBuilder;
        this.operationParser = operationParser;
        this.generalInfoBuilder = infoBuilder;
    }

    protected OpenAPI getOpenApi() {
        Instant start = Instant.now();
        this.generalInfoBuilder.build(this.openAPIBuilder.getOpenAPI());
        Map restControllersMap = this.context.getBeansWithAnnotation(RestController.class);
        Map requestMappingMap = this.context.getBeansWithAnnotation(RequestMapping.class);
        Map<String, Object> restControllers = Stream.of(restControllersMap, requestMappingMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
        Map findControllerAdvice = this.context.getBeansWithAnnotation(ControllerAdvice.class);
        this.responseBuilder.buildGenericResponse(this.openAPIBuilder.getComponents(), findControllerAdvice);
        this.getPaths(restControllers);
        LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
        return this.openAPIBuilder.getOpenAPI();
    }

    protected abstract void getPaths(Map<String, Object> var1);

    protected void calculatePath(OpenAPIBuilder openAPIBuilder, HandlerMethod handlerMethod, String operationPath, Set<RequestMethod> requestMethods) {
        OpenAPI openAPI = openAPIBuilder.getOpenAPI();
        Components components = openAPIBuilder.getComponents();
        Paths paths = openAPIBuilder.getPaths();
        for (RequestMethod requestMethod : requestMethods) {
            boolean hiddenMethod;
            io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)ReflectionUtils.getAnnotation((Method)handlerMethod.getMethod(), io.swagger.v3.oas.annotations.Operation.class);
            boolean bl = hiddenMethod = ReflectionUtils.getAnnotation((Method)handlerMethod.getMethod(), Hidden.class) != null;
            if (apiOperation != null && (apiOperation.hidden() || hiddenMethod)) continue;
            RequestMapping reqMappringClass = (RequestMapping)ReflectionUtils.getAnnotation((Class)handlerMethod.getBeanType(), RequestMapping.class);
            MediaAttributes mediaAttributes = new MediaAttributes();
            if (reqMappringClass != null) {
                mediaAttributes.setClassConsumes(reqMappringClass.consumes());
                mediaAttributes.setClassProduces(reqMappringClass.produces());
            }
            mediaAttributes.calculateConsumesProduces(requestMethod, handlerMethod.getMethod());
            Operation operation = new Operation();
            operation = this.tagbuiBuilder.build(handlerMethod, operation, openAPI);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(components, apiOperation, operation, openAPI, mediaAttributes);
            }
            operation = this.requestBuilder.build(components, handlerMethod, requestMethod, operation, mediaAttributes);
            ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, mediaAttributes.getAllProduces());
            operation.setResponses(apiResponses);
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    private PathItem buildPathItem(RequestMethod requestMethod, Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }

    @Autowired
    public void setContext(ApplicationContext context) {
        this.context = context;
    }
}

