/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.util.Set;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.InfoBuilder;
import org.springdoc.core.MediaAttributes;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.TagsBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOpenApiResource {
    @Autowired
    protected OpenAPIBuilder openAPIBuilder;
    @Autowired
    protected AbstractRequestBuilder requestBuilder;
    @Autowired
    protected AbstractResponseBuilder responseBuilder;
    @Autowired
    protected TagsBuilder tagbuiBuilder;
    @Autowired
    protected OperationBuilder operationParser;
    @Autowired
    protected InfoBuilder infoBuilder;

    protected void calculatePath(OpenAPIBuilder openAPIBuilder, HandlerMethod handlerMethod, String operationPath, Set<RequestMethod> requestMethods) {
        OpenAPI openAPI = openAPIBuilder.getOpenAPI();
        Components components = openAPIBuilder.getComponents();
        Paths paths = openAPIBuilder.getPaths();
        for (RequestMethod requestMethod : requestMethods) {
            io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)ReflectionUtils.getAnnotation((Method)handlerMethod.getMethod(), io.swagger.v3.oas.annotations.Operation.class);
            if (apiOperation != null && apiOperation.hidden()) continue;
            RequestMapping reqMappringClass = (RequestMapping)ReflectionUtils.getAnnotation((Class)handlerMethod.getBeanType(), RequestMapping.class);
            MediaAttributes mediaAttributes = new MediaAttributes();
            if (reqMappringClass != null) {
                mediaAttributes.setClassConsumes(reqMappringClass.consumes());
                mediaAttributes.setClassProduces(reqMappringClass.produces());
            }
            mediaAttributes.calculateConsumesProduces(requestMethod, handlerMethod.getMethod());
            Operation operation = new Operation();
            operation = this.tagbuiBuilder.build(handlerMethod, operation, openAPI);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(components, apiOperation, operation, openAPI, mediaAttributes);
            }
            operation = this.requestBuilder.build(components, handlerMethod, requestMethod, operation, mediaAttributes);
            ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, mediaAttributes.getAllProduces());
            operation.setResponses(apiResponses);
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    protected PathItem buildPathItem(RequestMethod requestMethod, Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }
}

