/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.config;

import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springblade.core.tool.request.BladeRequestFilter;
import org.springblade.core.tool.request.RequestProperties;
import org.springblade.core.tool.request.XssProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RequestProperties.class, XssProperties.class})
public class RequestConfiguration {
    private final RequestProperties requestProperties;
    private final XssProperties xssProperties;

    @Bean
    public FilterRegistrationBean<BladeRequestFilter> bladeFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        registration.setFilter((Filter)new BladeRequestFilter(this.requestProperties, this.xssProperties));
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("bladeRequestFilter");
        registration.setOrder(Integer.MAX_VALUE);
        return registration;
    }

    public RequestConfiguration(RequestProperties requestProperties, XssProperties xssProperties) {
        this.requestProperties = requestProperties;
        this.xssProperties = xssProperties;
    }
}

