/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.log.utils;

import javax.servlet.http.HttpServletRequest;
import org.springblade.core.launch.props.BladeProperties;
import org.springblade.core.launch.server.ServerInfo;
import org.springblade.core.log.model.LogAbstract;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.core.tool.utils.UrlUtil;
import org.springblade.core.tool.utils.WebUtil;

public class LogAbstractUtil {
    public static void addRequestInfoToLog(HttpServletRequest request, LogAbstract logAbstract) {
        if (ObjectUtil.isNotEmpty((Object)request)) {
            logAbstract.setRemoteIp(WebUtil.getIP((HttpServletRequest)request));
            logAbstract.setUserAgent(request.getHeader("user-agent"));
            logAbstract.setRequestUri(UrlUtil.getPath((String)request.getRequestURI()));
            logAbstract.setMethod(request.getMethod());
            logAbstract.setParams(WebUtil.getRequestParamString((HttpServletRequest)request));
            logAbstract.setCreateBy(SecureUtil.getUserAccount((HttpServletRequest)request));
        }
    }

    public static void addOtherInfoToLog(LogAbstract logAbstract, BladeProperties bladeProperties, ServerInfo serverInfo) {
        logAbstract.setServiceId(bladeProperties.getName());
        logAbstract.setServerHost(serverInfo.getHostName());
        logAbstract.setServerIp(serverInfo.getIpWithPort());
        logAbstract.setEnv(bladeProperties.getEnv());
        logAbstract.setCreateTime(DateUtil.now());
        if (logAbstract.getParams() == null) {
            logAbstract.setParams("");
        }
    }
}

