/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.progress;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.springaicommunity.mcp.method.progress.AbstractMcpProgressMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncMcpProgressMethodCallback
extends AbstractMcpProgressMethodCallback
implements Function<McpSchema.ProgressNotification, Mono<Void>> {
    private AsyncMcpProgressMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    protected void validateReturnType(Method method) {
        Type genericReturnType;
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return;
        }
        if (Mono.class.isAssignableFrom(returnType) && (genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericReturnType;
            Type[] typeArguments = paramType.getActualTypeArguments();
            if (typeArguments.length == 1 && typeArguments[0] == Void.class) {
                return;
            }
            throw new IllegalArgumentException("Mono return type must be Mono<Void>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
        throw new IllegalArgumentException("Asynchronous progress methods must return void or Mono<Void>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
    }

    @Override
    public Mono<Void> apply(McpSchema.ProgressNotification notification) {
        if (notification == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Notification must not be null"));
        }
        return Mono.fromCallable(() -> {
            try {
                Object[] args = this.buildArgs(this.method, null, notification);
                this.method.setAccessible(true);
                Object result = this.method.invoke(this.bean, args);
                if (result instanceof Mono) {
                    return (Mono)result;
                }
                return Mono.empty();
            }
            catch (Exception e) {
                throw new AbstractMcpProgressMethodCallback.McpProgressMethodException("Error invoking progress method: " + this.method.getName(), e);
            }
        }).flatMap(mono -> mono.then());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpProgressMethodCallback.AbstractBuilder<Builder, AsyncMcpProgressMethodCallback> {
        @Override
        public AsyncMcpProgressMethodCallback build() {
            this.validate();
            return new AsyncMcpProgressMethodCallback(this);
        }
    }
}

