/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.changed.prompt;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import org.springaicommunity.mcp.method.changed.prompt.AbstractMcpPromptListChangedMethodCallback;

public final class SyncMcpPromptListChangedMethodCallback
extends AbstractMcpPromptListChangedMethodCallback
implements Consumer<List<McpSchema.Prompt>> {
    private SyncMcpPromptListChangedMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public void accept(List<McpSchema.Prompt> updatedPrompts) {
        if (updatedPrompts == null) {
            throw new IllegalArgumentException("Updated prompts list must not be null");
        }
        try {
            Object[] args = this.buildArgs(this.method, null, updatedPrompts);
            this.method.setAccessible(true);
            this.method.invoke(this.bean, args);
        }
        catch (Exception e) {
            throw new AbstractMcpPromptListChangedMethodCallback.McpPromptListChangedConsumerMethodException("Error invoking prompt list changed consumer method: " + this.method.getName(), e);
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            throw new IllegalArgumentException("Method must have void return type: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpPromptListChangedMethodCallback.AbstractBuilder<Builder, SyncMcpPromptListChangedMethodCallback> {
        @Override
        public SyncMcpPromptListChangedMethodCallback build() {
            this.validate();
            return new SyncMcpPromptListChangedMethodCallback(this);
        }
    }
}

