/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.prompt;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.method.prompt.AbstractMcpPromptMethodCallback;
import reactor.core.publisher.Mono;

public final class AsyncStatelessMcpPromptMethodCallback
extends AbstractMcpPromptMethodCallback
implements BiFunction<McpTransportContext, McpSchema.GetPromptRequest, Mono<McpSchema.GetPromptResult>> {
    private AsyncStatelessMcpPromptMethodCallback(Builder builder) {
        super(builder.method, builder.bean, builder.prompt);
    }

    @Override
    public Mono<McpSchema.GetPromptResult> apply(McpTransportContext context, McpSchema.GetPromptRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        return Mono.defer(() -> {
            try {
                Object[] args = this.buildArgs(this.method, context, request);
                this.method.setAccessible(true);
                Object result = this.method.invoke(this.bean, args);
                if (result instanceof Mono) {
                    return ((Mono)result).map(r -> this.convertToGetPromptResult(r));
                }
                return Mono.just((Object)this.convertToGetPromptResult(result));
            }
            catch (Exception e) {
                return Mono.error((Throwable)new AbstractMcpPromptMethodCallback.McpPromptMethodException("Error invoking prompt method: " + this.method.getName(), e));
            }
        });
    }

    @Override
    protected boolean isExchangeOrContextType(Class<?> paramType) {
        return McpTransportContext.class.isAssignableFrom(paramType);
    }

    @Override
    protected void validateReturnType(Method method) {
        boolean validReturnType;
        Class<?> returnType = method.getReturnType();
        boolean bl = validReturnType = McpSchema.GetPromptResult.class.isAssignableFrom(returnType) || List.class.isAssignableFrom(returnType) || McpSchema.PromptMessage.class.isAssignableFrom(returnType) || String.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
        if (!validReturnType) {
            throw new IllegalArgumentException("Method must return either GetPromptResult, List<PromptMessage>, List<String>, PromptMessage, String, or Mono<T>: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpPromptMethodCallback.AbstractBuilder<Builder, AsyncStatelessMcpPromptMethodCallback> {
        @Override
        public AsyncStatelessMcpPromptMethodCallback build() {
            this.validate();
            return new AsyncStatelessMcpPromptMethodCallback(this);
        }
    }
}

