/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;
import org.springaicommunity.mcp.annotation.McpMeta;
import org.springaicommunity.mcp.annotation.McpProgressToken;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;

public abstract class AbstractSyncMcpToolMethodCallback<T> {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    protected final Method toolMethod;
    protected final Object toolObject;
    protected final ReturnMode returnMode;

    protected AbstractSyncMcpToolMethodCallback(ReturnMode returnMode, Method toolMethod, Object toolObject) {
        this.toolMethod = toolMethod;
        this.toolObject = toolObject;
        this.returnMode = returnMode;
    }

    protected Object callMethod(Object[] methodArguments) {
        Object result;
        this.toolMethod.setAccessible(true);
        try {
            result = this.toolMethod.invoke(this.toolObject, methodArguments);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error invoking method: " + this.toolMethod.getName(), ex);
        }
        return result;
    }

    protected Object[] buildMethodArguments(T exchangeOrContext, Map<String, Object> toolInputArguments, McpSchema.CallToolRequest request) {
        return Stream.of(this.toolMethod.getParameters()).map(parameter -> {
            if (parameter.isAnnotationPresent(McpProgressToken.class)) {
                return request != null ? request.progressToken() : null;
            }
            if (McpMeta.class.isAssignableFrom(parameter.getType())) {
                return request != null ? new McpMeta(request.meta()) : new McpMeta(null);
            }
            if (McpSchema.CallToolRequest.class.isAssignableFrom(parameter.getType())) {
                return request;
            }
            if (this.isExchangeOrContextType(parameter.getType())) {
                return exchangeOrContext;
            }
            Object rawArgument = toolInputArguments.get(parameter.getName());
            return this.buildTypedArgument(rawArgument, parameter.getParameterizedType());
        }).toArray();
    }

    protected Object buildTypedArgument(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (type instanceof Class) {
            return JsonParser.toTypedObject(value, (Class)type);
        }
        String json = JsonParser.toJson(value);
        return JsonParser.fromJson(json, type);
    }

    protected McpSchema.CallToolResult processResult(Object result) {
        if (result instanceof McpSchema.CallToolResult) {
            return (McpSchema.CallToolResult)result;
        }
        if (this.returnMode == ReturnMode.VOID) {
            return McpSchema.CallToolResult.builder().addTextContent(JsonParser.toJson("Done")).build();
        }
        if (this.returnMode == ReturnMode.STRUCTURED) {
            String jsonOutput = JsonParser.toJson(result);
            Map<String, Object> structuredOutput = JsonParser.fromJson(jsonOutput, MAP_TYPE_REFERENCE);
            return McpSchema.CallToolResult.builder().structuredContent(structuredOutput).build();
        }
        return McpSchema.CallToolResult.builder().addTextContent(result != null ? result.toString() : "null").build();
    }

    protected McpSchema.CallToolResult createErrorResult(Exception e) {
        return McpSchema.CallToolResult.builder().isError(Boolean.valueOf(true)).addTextContent("Error invoking method: %s".formatted(e.getMessage())).build();
    }

    protected void validateRequest(McpSchema.CallToolRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null");
        }
    }

    protected abstract boolean isExchangeOrContextType(Class<?> var1);
}

