/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.progress;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.springaicommunity.mcp.method.progress.AbstractMcpProgressMethodCallback;

public final class SyncMcpProgressMethodCallback
extends AbstractMcpProgressMethodCallback
implements Consumer<McpSchema.ProgressNotification> {
    private SyncMcpProgressMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    protected void validateReturnType(Method method) {
        if (!Void.TYPE.equals(method.getReturnType())) {
            throw new IllegalArgumentException("Synchronous progress methods must return void: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + method.getReturnType().getName());
        }
    }

    @Override
    public void accept(McpSchema.ProgressNotification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Notification must not be null");
        }
        try {
            Object[] args = this.buildArgs(this.method, null, notification);
            this.method.setAccessible(true);
            this.method.invoke(this.bean, args);
        }
        catch (Exception e) {
            throw new AbstractMcpProgressMethodCallback.McpProgressMethodException("Error invoking progress method: " + this.method.getName(), e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpProgressMethodCallback.AbstractBuilder<Builder, SyncMcpProgressMethodCallback> {
        @Override
        public SyncMcpProgressMethodCallback build() {
            this.validate();
            return new SyncMcpProgressMethodCallback(this);
        }
    }
}

