/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.resource;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DeafaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManager;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springaicommunity.mcp.annotation.McpMeta;
import org.springaicommunity.mcp.annotation.McpProgressToken;
import org.springaicommunity.mcp.method.resource.McpReadResourceResultConverter;

public abstract class AbstractMcpResourceMethodCallback {
    protected final Method method;
    protected final Object bean;
    protected final String uri;
    protected final String name;
    protected final String description;
    protected final String mimeType;
    protected final List<String> uriVariables;
    protected final McpReadResourceResultConverter resultConverter;
    protected final McpUriTemplateManager uriTemplateManager;
    protected final ContentType contentType;

    protected AbstractMcpResourceMethodCallback(Method method, Object bean, String uri, String name, String description, String mimeType, McpReadResourceResultConverter resultConverter, McpUriTemplateManagerFactory uriTemplateMangerFactory, ContentType contentType) {
        Assert.hasText((String)uri, (String)"URI can't be null or empty!");
        Assert.notNull((Object)method, (String)"Method can't be null!");
        Assert.notNull((Object)bean, (String)"Bean can't be null!");
        Assert.notNull((Object)resultConverter, (String)"Result converter can't be null!");
        Assert.notNull((Object)uriTemplateMangerFactory, (String)"URI template manager factory can't be null!");
        this.method = method;
        this.bean = bean;
        this.uri = uri;
        this.name = name;
        this.description = description;
        this.mimeType = mimeType;
        this.resultConverter = resultConverter;
        this.uriTemplateManager = uriTemplateMangerFactory.create(this.uri);
        this.uriVariables = this.uriTemplateManager.getVariableNames();
        this.contentType = contentType;
    }

    protected void validateMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.validateReturnType(method);
        if (this.uriVariables.isEmpty()) {
            this.validateParametersWithoutUriVariables(method);
        } else {
            this.validateParametersWithUriVariables(method);
        }
    }

    protected abstract void validateReturnType(Method var1);

    protected void validateParametersWithoutUriVariables(Method method) {
        Parameter[] parameters = method.getParameters();
        int nonSpecialParamCount = 0;
        for (Parameter param : parameters) {
            if (param.isAnnotationPresent(McpProgressToken.class) || McpMeta.class.isAssignableFrom(param.getType())) continue;
            ++nonSpecialParamCount;
        }
        if (nonSpecialParamCount > 2) {
            throw new IllegalArgumentException("Method can have at most 2 input parameters (excluding @McpProgressToken and McpMeta) when no URI variables are present: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has " + nonSpecialParamCount + " non-special parameters");
        }
        boolean hasValidParams = false;
        boolean hasExchangeParam = false;
        boolean hasRequestOrUriParam = false;
        boolean hasMetaParam = false;
        for (Parameter param : parameters) {
            if (param.isAnnotationPresent(McpProgressToken.class)) continue;
            Class<?> paramType = param.getType();
            if (McpMeta.class.isAssignableFrom(paramType)) {
                if (hasMetaParam) {
                    throw new IllegalArgumentException("Method cannot have more than one McpMeta parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasMetaParam = true;
                continue;
            }
            if (this.isExchangeOrContextType(paramType)) {
                if (hasExchangeParam) {
                    throw new IllegalArgumentException("Method cannot have more than one exchange parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasExchangeParam = true;
                continue;
            }
            if (McpSchema.ReadResourceRequest.class.isAssignableFrom(paramType) || String.class.isAssignableFrom(paramType)) {
                if (hasRequestOrUriParam) {
                    throw new IllegalArgumentException("Method cannot have more than one ReadResourceRequest or String parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
                }
                hasRequestOrUriParam = true;
                hasValidParams = true;
                continue;
            }
            throw new IllegalArgumentException("Method parameters must be exchange, ReadResourceRequest, String, McpMeta, or @McpProgressToken when no URI variables are present: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + paramType.getName());
        }
        if (!hasValidParams && nonSpecialParamCount > 0) {
            throw new IllegalArgumentException("Method must have either ReadResourceRequest or String parameter when no URI variables are present: " + method.getName() + " in " + method.getDeclaringClass().getName());
        }
    }

    protected void validateParametersWithUriVariables(Method method) {
        Parameter[] parameters = method.getParameters();
        int exchangeParamCount = 0;
        int requestParamCount = 0;
        int progressTokenParamCount = 0;
        int metaParamCount = 0;
        for (Parameter param : parameters) {
            if (param.isAnnotationPresent(McpProgressToken.class)) {
                ++progressTokenParamCount;
                continue;
            }
            Class<?> paramType = param.getType();
            if (McpMeta.class.isAssignableFrom(paramType)) {
                ++metaParamCount;
                continue;
            }
            if (this.isExchangeOrContextType(paramType)) {
                ++exchangeParamCount;
                continue;
            }
            if (!McpSchema.ReadResourceRequest.class.isAssignableFrom(paramType)) continue;
            ++requestParamCount;
        }
        if (exchangeParamCount > 1) {
            throw new IllegalArgumentException("Method cannot have more than one exchange parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
        }
        if (requestParamCount > 1) {
            throw new IllegalArgumentException("Method cannot have more than one ReadResourceRequest parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
        }
        if (metaParamCount > 1) {
            throw new IllegalArgumentException("Method cannot have more than one McpMeta parameter: " + method.getName() + " in " + method.getDeclaringClass().getName());
        }
        int specialParamCount = exchangeParamCount + requestParamCount + progressTokenParamCount + metaParamCount;
        int uriVarParamCount = parameters.length - specialParamCount;
        if (uriVarParamCount != this.uriVariables.size()) {
            throw new IllegalArgumentException("Method must have parameters for all URI variables. Expected " + this.uriVariables.size() + " URI variable parameters, but found " + uriVarParamCount + ": " + method.getName() + " in " + method.getDeclaringClass().getName() + ". URI variables: " + String.valueOf(this.uriVariables));
        }
        for (Parameter param : parameters) {
            Class<?> paramType;
            if (param.isAnnotationPresent(McpProgressToken.class) || this.isExchangeOrContextType(paramType = param.getType()) || McpSchema.ReadResourceRequest.class.isAssignableFrom(paramType) || McpMeta.class.isAssignableFrom(paramType) || String.class.isAssignableFrom(paramType)) continue;
            throw new IllegalArgumentException("URI variable parameters must be of type String: " + method.getName() + " in " + method.getDeclaringClass().getName() + ", parameter of type " + paramType.getName() + " is not valid");
        }
    }

    protected Object[] buildArgs(Method method, Object exchange, McpSchema.ReadResourceRequest request, Map<String, String> uriVariableValues) {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(McpProgressToken.class)) {
                args[i] = request != null ? request.progressToken() : null;
                continue;
            }
            if (!McpMeta.class.isAssignableFrom(parameters[i].getType())) continue;
            args[i] = request != null ? new McpMeta(request.meta()) : new McpMeta(null);
        }
        if (!this.uriVariables.isEmpty()) {
            this.buildArgsWithUriVariables(parameters, args, exchange, request, uriVariableValues);
        } else {
            this.buildArgsWithoutUriVariables(parameters, args, exchange, request);
        }
        return args;
    }

    protected void buildArgsWithUriVariables(Parameter[] parameters, Object[] args, Object exchange, McpSchema.ReadResourceRequest request, Map<String, String> uriVariableValues) {
        ArrayList<String> assignedVariables = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(McpProgressToken.class) || McpMeta.class.isAssignableFrom(parameters[i].getType())) continue;
            Class<?> paramType = parameters[i].getType();
            if (this.isExchangeOrContextType(paramType)) {
                args[i] = exchange;
                continue;
            }
            if (!McpSchema.ReadResourceRequest.class.isAssignableFrom(paramType)) continue;
            args[i] = request;
        }
        int variableIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(McpProgressToken.class) || McpMeta.class.isAssignableFrom(parameters[i].getType()) || args[i] != null || variableIndex >= this.uriVariables.size()) continue;
            String variableName = this.uriVariables.get(variableIndex);
            args[i] = uriVariableValues.get(variableName);
            assignedVariables.add(variableName);
            ++variableIndex;
        }
        if (assignedVariables.size() != this.uriVariables.size()) {
            throw new IllegalArgumentException("Failed to assign all URI variables to method parameters. Assigned: " + String.valueOf(assignedVariables) + ", Expected: " + String.valueOf(this.uriVariables));
        }
    }

    protected void buildArgsWithoutUriVariables(Parameter[] parameters, Object[] args, Object exchange, McpSchema.ReadResourceRequest request) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(McpProgressToken.class) || McpMeta.class.isAssignableFrom(parameters[i].getType())) continue;
            Parameter param = parameters[i];
            Class<?> paramType = param.getType();
            args[i] = this.isExchangeOrContextType(paramType) ? exchange : (McpSchema.ReadResourceRequest.class.isAssignableFrom(paramType) ? request : (String.class.isAssignableFrom(paramType) ? request.uri() : null));
        }
    }

    protected abstract boolean isExchangeOrContextType(Class<?> var1);

    public ContentType contentType() {
        return this.contentType;
    }

    public static enum ContentType {
        TEXT,
        BLOB;

    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, R>, R> {
        protected Method method;
        protected Object bean;
        protected McpReadResourceResultConverter resultConverter;
        protected McpUriTemplateManagerFactory uriTemplateManagerFactory;
        protected ContentType contentType;
        protected String name;
        protected String description;
        protected String mimeType;
        protected String uri;

        protected AbstractBuilder() {
        }

        public T method(Method method) {
            this.method = method;
            return (T)this;
        }

        public T bean(Object bean) {
            this.bean = bean;
            return (T)this;
        }

        public T uri(String uri) {
            this.uri = uri;
            return (T)this;
        }

        public T resource(McpSchema.Resource resource) {
            this.uri = resource.uri();
            this.name = resource.name();
            this.description = resource.description();
            this.mimeType = resource.mimeType();
            return (T)this;
        }

        public T resource(McpSchema.ResourceTemplate resourceTemplate) {
            this.uri = resourceTemplate.uriTemplate();
            this.name = resourceTemplate.name();
            this.description = resourceTemplate.description();
            this.mimeType = resourceTemplate.mimeType();
            return (T)this;
        }

        public T resultConverter(McpReadResourceResultConverter resultConverter) {
            this.resultConverter = resultConverter;
            return (T)this;
        }

        public T uriTemplateManagerFactory(McpUriTemplateManagerFactory uriTemplateManagerFactory) {
            this.uriTemplateManagerFactory = uriTemplateManagerFactory;
            return (T)this;
        }

        public T contentType(ContentType contentType) {
            this.contentType = contentType;
            return (T)this;
        }

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T description(String description) {
            this.description = description;
            return (T)this;
        }

        public T mimeType(String mimeType) {
            this.mimeType = mimeType;
            return (T)this;
        }

        protected void validate() {
            if (this.method == null) {
                throw new IllegalArgumentException("Method must not be null");
            }
            if (this.bean == null) {
                throw new IllegalArgumentException("Bean must not be null");
            }
            if (this.uri == null || this.uri.isEmpty()) {
                throw new IllegalArgumentException("URI must not be null or empty");
            }
            if (this.uriTemplateManagerFactory == null) {
                this.uriTemplateManagerFactory = new DeafaultMcpUriTemplateManagerFactory();
            }
            if (this.mimeType == null) {
                this.mimeType = "text/plain";
            }
            if (this.name == null) {
                this.name = this.method.getName();
            }
        }

        public abstract R build();
    }

    public static class McpResourceMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public McpResourceMethodException(String message, Throwable cause) {
            super(message, cause);
        }

        public McpResourceMethodException(String message) {
            super(message);
        }
    }
}

