/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.spring.UnwrapAopProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;

public class UnwrapAopProxyExtension
implements IAnnotationDrivenExtension<UnwrapAopProxy> {
    public void visitFieldAnnotation(UnwrapAopProxy annotation, FieldInfo field) {
        ((SpecInfo)field.getParent()).addSetupInterceptor((IMethodInterceptor)new UnwrapMethodInterceptor(field));
    }

    public static <T> T getUltimateTargetObject(Object candidate) {
        Assert.notNull((Object)candidate, (String)"Candidate must not be null");
        try {
            Object target;
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised && (target = ((Advised)candidate).getTargetSource().getTarget()) != null) {
                return UnwrapAopProxyExtension.getUltimateTargetObject(target);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }

    private static class UnwrapMethodInterceptor
    implements IMethodInterceptor {
        private final FieldInfo field;

        public UnwrapMethodInterceptor(FieldInfo field) {
            this.field = field;
        }

        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object value = this.field.readValue(invocation.getInstance());
            if ((value = UnwrapAopProxyExtension.getUltimateTargetObject(value)) != null) {
                this.field.writeValue(invocation.getInstance(), value);
            }
            invocation.proceed();
        }
    }
}

