/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.lang.reflect.Method;
import org.spockframework.runtime.extension.AbstractMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.spring.EnableSharedInjection;
import org.spockframework.spring.SpringTestContextManager;

public class SpringInterceptor
extends AbstractMethodInterceptor {
    private final SpringTestContextManager manager;
    private Throwable exception;
    private boolean beforeTestMethodInvoked = false;

    public SpringInterceptor(SpringTestContextManager manager) {
        this.manager = manager;
    }

    public void interceptSetupSpecMethod(IMethodInvocation invocation) throws Throwable {
        this.manager.beforeTestClass();
        if (invocation.getSpec().isAnnotationPresent(EnableSharedInjection.class)) {
            this.manager.prepareTestInstance(invocation.getInstance());
        }
        invocation.proceed();
    }

    public void interceptInitializerMethod(IMethodInvocation invocation) throws Throwable {
        invocation.proceed();
        this.manager.prepareTestInstance(invocation.getInstance());
    }

    public void interceptSetupMethod(IMethodInvocation invocation) throws Throwable {
        this.exception = null;
        this.beforeTestMethodInvoked = true;
        this.manager.beforeTestMethod(invocation.getInstance(), (Method)invocation.getFeature().getFeatureMethod().getReflection());
        invocation.proceed();
    }

    public void interceptCleanupMethod(IMethodInvocation invocation) throws Throwable {
        if (!this.beforeTestMethodInvoked) {
            invocation.proceed();
            return;
        }
        this.beforeTestMethodInvoked = false;
        invocation.proceed();
        Throwable afterTestMethodEx = null;
        try {
            this.manager.afterTestMethod(invocation.getInstance(), (Method)invocation.getFeature().getFeatureMethod().getReflection(), this.exception);
        }
        catch (Throwable t) {
            afterTestMethodEx = t;
        }
        if (afterTestMethodEx != null) {
            if (this.exception == null) {
                throw afterTestMethodEx;
            }
            this.exception.addSuppressed(afterTestMethodEx);
        }
    }

    public void interceptCleanupSpecMethod(IMethodInvocation invocation) throws Throwable {
        invocation.proceed();
        Throwable afterTestClassEx = null;
        try {
            this.manager.afterTestClass();
        }
        catch (Throwable t) {
            afterTestClassEx = t;
        }
        if (afterTestClassEx != null) {
            if (this.exception == null) {
                throw afterTestClassEx;
            }
            this.exception.addSuppressed(afterTestClassEx);
        }
    }

    public void error(ErrorInfo error) {
        if (this.exception == null) {
            this.exception = error.getException();
        }
    }
}

