/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Specification;

public class JUnit4AnnotationLifecycleMethodsExtension
implements IGlobalExtension {
    public void visitSpec(SpecInfo spec) {
        Class clazz = (Class)spec.getReflection();
        new JUnit4LifecycleSpecInfoEnhancer(spec, clazz, clazz).enhance();
    }

    private static class JUnit4LifecycleSpecInfoEnhancer {
        private final SpecInfo spec;
        private final Class<?> clazz;
        private final Class<?> effectiveClass;

        private JUnit4LifecycleSpecInfoEnhancer(SpecInfo spec, Class<?> clazz, Class<?> effectiveClass) {
            this.spec = spec;
            this.clazz = clazz;
            this.effectiveClass = effectiveClass;
        }

        void enhance() {
            this.handleSuperSpec();
            for (Method method : this.clazz.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Before.class)) {
                    this.spec.addSetupMethod(this.createJUnitFixtureMethod(method, MethodKind.SETUP, Before.class));
                }
                if (method.isAnnotationPresent(After.class)) {
                    this.spec.addCleanupMethod(this.createJUnitFixtureMethod(method, MethodKind.CLEANUP, After.class));
                }
                if (method.isAnnotationPresent(BeforeClass.class)) {
                    this.spec.addSetupSpecMethod(this.createJUnitFixtureMethod(method, MethodKind.SETUP_SPEC, BeforeClass.class));
                }
                if (!method.isAnnotationPresent(AfterClass.class)) continue;
                this.spec.addCleanupSpecMethod(this.createJUnitFixtureMethod(method, MethodKind.CLEANUP_SPEC, AfterClass.class));
            }
        }

        private void handleSuperSpec() {
            Class superClass = ((Class)this.spec.getReflection()).getSuperclass();
            if (superClass != Object.class && superClass != Specification.class) {
                new JUnit4LifecycleSpecInfoEnhancer(this.spec.getSuperSpec(), superClass, this.clazz).enhance();
            }
        }

        private MethodInfo createJUnitFixtureMethod(Method method, MethodKind kind, Class<? extends Annotation> annotation) {
            MethodInfo methodInfo = this.createMethod(method, kind, method.getName());
            methodInfo.setExcluded(this.isOverriddenJUnitFixtureMethod(method, annotation));
            return methodInfo;
        }

        private MethodInfo createMethod(Method method, MethodKind kind, String name) {
            MethodInfo methodInfo = new MethodInfo();
            methodInfo.setParent((NodeInfo)this.spec);
            methodInfo.setName(name);
            methodInfo.setReflection((AnnotatedElement)method);
            methodInfo.setKind(kind);
            return methodInfo;
        }

        private boolean isOverriddenJUnitFixtureMethod(Method method, Class<? extends Annotation> annotation) {
            if (Modifier.isPrivate(method.getModifiers())) {
                return false;
            }
            for (Class<?> currClass = this.effectiveClass; currClass != this.clazz; currClass = currClass.getSuperclass()) {
                for (Method currMethod : currClass.getDeclaredMethods()) {
                    if (!currMethod.isAnnotationPresent(annotation) || !currMethod.getName().equals(method.getName()) || !Arrays.deepEquals(currMethod.getParameterTypes(), method.getParameterTypes())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

