/*
 * Decompiled with CFR 0.152.
 */
package spire.math.fpf;

import scala.math.BigDecimal;
import scala.math.BigInt;
import spire.math.Rational;
import spire.math.package$;

public final class FastMaybeFloat$ {
    public static final FastMaybeFloat$ MODULE$;
    private final long Invalid;
    private final float eps;
    private final long indexMask;
    private final long measureMask;
    private final long approxMask;
    private final long invalidMask;

    static {
        new FastMaybeFloat$();
    }

    public final long Invalid() {
        return -1L;
    }

    public final float eps() {
        return this.eps;
    }

    private final long indexMask() {
        return 32767L;
    }

    private final long measureMask() {
        return 549755781120L;
    }

    private final long approxMask() {
        return -549755813888L;
    }

    private final long invalidMask() {
        return 9187343239835811840L;
    }

    public float asFloat(long x) {
        return Float.intBitsToFloat((int)x);
    }

    public int max(int a, int b) {
        return a > b ? a : b;
    }

    public int min(int a, int b) {
        return a < b ? a : b;
    }

    public boolean invalid(long a) {
        return (a & 0x7F80000000000000L) == 9187343239835811840L;
    }

    public final float approx(long mf) {
        return Float.intBitsToFloat((int)((mf & 0xFFFFFF8000000000L) >>> 32));
    }

    public final float measure(long mf) {
        return this.asFloat((mf & 0x7FFFFF8000L) >>> 8);
    }

    public final int index(long mf) {
        return (int)(mf & 0x7FFFL);
    }

    public final float error(long mf) {
        return Float.intBitsToFloat((int)((mf & 0x7FFFFF8000L) >>> 8)) * (float)((int)(mf & 0x7FFFL)) * this.eps();
    }

    private final long applySafe(float a, float m, int i) {
        return this.spire$math$fpf$FastMaybeFloat$$apply(a, m, this.min(i, 65536));
    }

    public final long spire$math$fpf$FastMaybeFloat$$apply(float a, float m, int i) {
        long x = (long)Float.floatToIntBits(a) << 17 & 0xFFFFFFFFFF000000L | (long)(Float.floatToIntBits(m) >>> 7);
        return x << 15 | (long)i << 48 >> 48;
    }

    public final long plus(long a, long b) {
        int n;
        int n2;
        return this.spire$math$fpf$FastMaybeFloat$$apply(this.approx(a) + this.approx(b), Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8)) + Float.intBitsToFloat((int)((b & 0x7FFFFF8000L) >>> 8)), ((n2 = (int)(a & 0x7FFFL)) > (n = (int)(b & 0x7FFFL)) ? n2 : n) + 1);
    }

    public final long minus(long a, long b) {
        int n;
        int n2;
        return this.spire$math$fpf$FastMaybeFloat$$apply(this.approx(a) - this.approx(b), Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8)) + Float.intBitsToFloat((int)((b & 0x7FFFFF8000L) >>> 8)), ((n2 = (int)(a & 0x7FFFL)) > (n = (int)(b & 0x7FFFL)) ? n2 : n) + 1);
    }

    public final long times(long a, long b) {
        return this.spire$math$fpf$FastMaybeFloat$$apply(this.approx(a) * this.approx(b), Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8)) * Float.intBitsToFloat((int)((b & 0x7FFFFF8000L) >>> 8)), (int)(a & 0x7FFFL) + (int)(b & 0x7FFFL) + 1);
    }

    public final long div(long a, long b) {
        int n;
        int n2;
        float fa = this.approx(a);
        float fb = this.approx(b);
        float ma = Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8));
        float mb = Float.intBitsToFloat((int)((b & 0x7FFFFF8000L) >>> 8));
        int ib = (int)(b & 0x7FFFL);
        return this.spire$math$fpf$FastMaybeFloat$$apply(fa / fb, (package$.MODULE$.abs(fa) / package$.MODULE$.abs(fb) + ma / mb) / (package$.MODULE$.abs(fb) / mb - (float)(ib + 1) * this.eps()), 1 + ((n2 = (int)(a & 0x7FFFL)) > (n = ib + 1) ? n2 : n));
    }

    public long pow(long a, int k) {
        long l;
        if (k > 0) {
            l = this.spire$math$fpf$FastMaybeFloat$$apply((float)scala.math.package$.MODULE$.pow((double)this.approx(a), (double)k), (float)scala.math.package$.MODULE$.pow((double)Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8)), (double)k), (int)(a & 0x7FFFL) + k);
        } else if (k < 0) {
            float fb = (float)scala.math.package$.MODULE$.pow((double)this.approx(a), (double)(-k));
            float mb = (float)scala.math.package$.MODULE$.pow((double)Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8)), (double)(-k));
            int ib = (int)(a & 0x7FFFL) + k;
            float mes = (1.0f / package$.MODULE$.abs(fb) + 1.0f / mb) / (package$.MODULE$.abs(fb) / mb - (mb + 1.0f) * this.eps());
            l = this.spire$math$fpf$FastMaybeFloat$$apply(1.0f / fb, mes, ib + 2);
        } else {
            l = this.spire$math$fpf$FastMaybeFloat$$apply(1.0f, 1.0f, 0);
        }
        return l;
    }

    public long nroot(long a, int n) {
        return n == 2 ? this.sqrt(a) : -1L;
    }

    public long sqrt(long a) {
        long l;
        float fa = this.approx(a);
        if ((a & 0x7F80000000000000L) == 9187343239835811840L || fa <= 0.0f) {
            l = this.spire$math$fpf$FastMaybeFloat$$apply((float)scala.math.package$.MODULE$.sqrt((double)fa), (float)scala.math.package$.MODULE$.sqrt((double)Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8))) * (float)16, (int)(a & 0x7FFFL) + 1);
        } else {
            float fb = (float)scala.math.package$.MODULE$.sqrt((double)fa);
            l = this.spire$math$fpf$FastMaybeFloat$$apply(fb, Float.intBitsToFloat((int)((a & 0x7FFFFF8000L) >>> 8)) / fa * fb, (int)(a & 0x7FFFL) + 1);
        }
        return l;
    }

    public long apply(float x) {
        return this.spire$math$fpf$FastMaybeFloat$$apply(x, x, 1);
    }

    public long apply(double x) {
        return this.spire$math$fpf$FastMaybeFloat$$apply((float)x, (float)x, 1);
    }

    public long apply(int x) {
        return this.spire$math$fpf$FastMaybeFloat$$apply(x, x, 1);
    }

    public long apply(long x) {
        return this.spire$math$fpf$FastMaybeFloat$$apply(x, x, 1);
    }

    public long apply(BigInt x) {
        float f = x.toFloat();
        return this.spire$math$fpf$FastMaybeFloat$$apply(f, f, 1);
    }

    public long apply(BigDecimal x) {
        float f = x.toFloat();
        return this.spire$math$fpf$FastMaybeFloat$$apply(f, f, 1);
    }

    public long apply(Rational x) {
        float f = x.toFloat();
        return this.spire$math$fpf$FastMaybeFloat$$apply(f, f, 1);
    }

    private FastMaybeFloat$() {
        MODULE$ = this;
        this.eps = Float.intBitsToFloat(931135488);
    }
}

