/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

public final class StackTrace {
    private final StackTraceElement[] stackTrace;
    private final int relevantFramesStart;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public StackTrace(StackTraceElement[] stackTrace, int relevantFramesStart) {
        this.stackTrace = stackTrace;
        this.relevantFramesStart = relevantFramesStart;
    }

    public static StackTrace from(StackTraceElement[] stackTrace, int relevantFramesStart) {
        return new StackTrace(stackTrace, relevantFramesStart);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public int hashCode() {
        int hash = 7;
        return 53 * hash + Arrays.deepHashCode(this.stackTrace);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackTrace other = (StackTrace)obj;
        return org.spf4j.base.Arrays.deepEquals(this.stackTrace, other.stackTrace, this.relevantFramesStart);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = this.relevantFramesStart; i < this.stackTrace.length; ++i) {
            StackTraceElement elem = this.stackTrace[i];
            result.append(elem.getMethodName()).append('@').append(elem.getClassName()).append("->");
        }
        return result.toString();
    }
}

