/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ssdump2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.spf4j.base.Handler;
import org.spf4j.base.Method;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.ssdump2.avro.AMethod;
import org.spf4j.ssdump2.avro.ASample;
import org.spf4j.stackmonitor.SampleNode;

public final class Converter {
    private Converter() {
    }

    public static <E extends Exception> int convert(Method method, SampleNode node, int parentId, int id, Handler<ASample, E> handler) throws E {
        ASample sample = new ASample();
        sample.id = id;
        sample.count = node.getSampleCount();
        AMethod m = new AMethod();
        m.setName(method.getMethodName());
        m.setDeclaringClass(method.getDeclaringClass());
        sample.method = m;
        sample.parentId = parentId;
        handler.handle(sample, Long.MAX_VALUE);
        TMap<Method, SampleNode> subNodes = node.getSubNodes();
        int nid = id + 1;
        if (subNodes != null) {
            TObjectObjectProcedureImpl<E> proc = new TObjectObjectProcedureImpl<E>(id, handler);
            subNodes.forEachEntry(proc);
            nid = proc.getNid();
        }
        return nid;
    }

    public static SampleNode convert(Iterator<ASample> samples) {
        TIntObjectHashMap index = new TIntObjectHashMap();
        while (samples.hasNext()) {
            ASample asmp = samples.next();
            SampleNode sn = new SampleNode(asmp.count, (TMap<Method, SampleNode>)new THashMap());
            SampleNode parent = (SampleNode)index.get(asmp.parentId);
            if (parent != null) {
                AMethod method = asmp.getMethod();
                Method m = Method.getMethod(method.declaringClass, method.getName());
                TMap<Method, SampleNode> subNodes = parent.getSubNodes();
                if (subNodes == null) {
                    throw new IllegalStateException("Bug, state " + index + "; at node " + (Object)((Object)asmp));
                }
                subNodes.put(m, sn);
            }
            index.put(asmp.id, (Object)sn);
        }
        return (SampleNode)index.get(0);
    }

    public static void save(File file, SampleNode collected) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            final SpecificDatumWriter writer = new SpecificDatumWriter(ASample.SCHEMA$);
            final BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)bos, null);
            Converter.convert(Method.ROOT, collected, -1, 0, new Handler<ASample, IOException>(){

                @Override
                public void handle(ASample object, long deadline) throws IOException {
                    writer.write((Object)object, (Encoder)encoder);
                }
            });
            encoder.flush();
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static SampleNode load(File file) throws IOException {
        try (MemorizingBufferedInputStream bis = new MemorizingBufferedInputStream(new FileInputStream(file));){
            final PushbackInputStream pis = new PushbackInputStream(bis);
            final SpecificDatumReader reader = new SpecificDatumReader(ASample.SCHEMA$);
            final BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)pis, null);
            SampleNode sampleNode = Converter.convert(new Iterator<ASample>(){

                @Override
                public boolean hasNext() {
                    try {
                        int read = pis.read();
                        pis.unread(read);
                        return read >= 0;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                @SuppressFBWarnings
                public ASample next() {
                    try {
                        return (ASample)((Object)reader.read(null, (Decoder)decoder));
                    }
                    catch (IOException ex) {
                        NoSuchElementException e = new NoSuchElementException();
                        e.addSuppressed(ex);
                        throw e;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            });
            return sampleNode;
        }
    }

    private static final class TObjectObjectProcedureImpl<E extends Exception>
    implements TObjectObjectProcedure<Method, SampleNode> {
        private final int id;
        private final Handler<ASample, E> handler;
        private int nid;

        TObjectObjectProcedureImpl(int id, Handler<ASample, E> handler) {
            this.id = id;
            this.handler = handler;
            this.nid = id + 1;
        }

        public boolean execute(Method a, SampleNode b) {
            try {
                this.nid = Converter.convert(a, b, this.id, this.nid, this.handler);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return true;
        }

        public int getNid() {
            return this.nid;
        }
    }
}

