/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.spf4j.base.IntMath;
import org.spf4j.base.ReferenceType;
import org.spf4j.recyclable.SizedRecyclingSupplier;

public final class Powerof2SizedGlobalRecyclingSupplier<T>
implements SizedRecyclingSupplier<T> {
    private final SizedRecyclingSupplier.Factory<T> factory;
    private final ReferenceType refType;
    private final BlockingQueue<Reference<T>>[] objects;

    public Powerof2SizedGlobalRecyclingSupplier(SizedRecyclingSupplier.Factory<T> factory, ReferenceType refType) {
        this.factory = factory;
        this.refType = refType;
        this.objects = new BlockingQueue[28];
        for (int i = 0; i < this.objects.length; ++i) {
            this.objects[i] = new LinkedBlockingQueue<Reference<T>>();
        }
    }

    @Override
    public T get(int size) {
        Reference ref;
        Object result;
        int idx = IntMath.closestPowerOf2(size);
        BlockingQueue<Reference<T>> refs = this.objects[idx];
        do {
            if ((ref = (Reference)refs.poll()) != null) continue;
            int actualSize = 1 << idx;
            return this.factory.create(actualSize);
        } while ((result = ref.get()) == null);
        return result;
    }

    @Override
    public void recycle(T object) {
        int size = this.factory.size(object);
        int idx = IntMath.closestPowerOf2(size);
        BlockingQueue<Reference<T>> refs = this.objects[idx];
        refs.add(this.refType.create(object));
    }

    public String toString() {
        return "Powerof2SizedGlobalRecyclingSupplier{factory=" + this.factory + ", refType=" + (Object)((Object)this.refType) + ", objects=" + Arrays.toString(this.objects) + '}';
    }
}

