/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.util.concurrent.TimeoutException;
import org.spf4j.recyclable.Lease;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;

public final class LeaseImpl<T>
implements Lease<T> {
    private final T leased;
    private final RecyclingSupplier<T> rs;

    public LeaseImpl(RecyclingSupplier<T> rs) {
        this.rs = rs;
        try {
            this.leased = rs.get();
        }
        catch (InterruptedException | TimeoutException | ObjectBorrowException | ObjectCreationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public T get() {
        return this.leased;
    }

    @Override
    public void close() {
        this.rs.recycle(this.leased);
    }

    public String toString() {
        return "LeaseImpl{leased=" + this.leased + '}';
    }
}

