/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeoutException;
import org.spf4j.base.Callables;
import org.spf4j.base.Handler;
import org.spf4j.base.Throwables;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;

public final class Template<T, E extends Exception> {
    private final RecyclingSupplier<T> pool;
    private final int nrImmediateRetries;
    private final int retryWaitMillis;
    private final int timeout;

    public Template(RecyclingSupplier<T> pool, int nrImmediateRetries, int retryWaitMillis, int timeoutMillis) {
        this.pool = pool;
        this.nrImmediateRetries = nrImmediateRetries;
        this.retryWaitMillis = retryWaitMillis;
        this.timeout = timeoutMillis;
    }

    public void doOnSupplied(Handler<T, E> handler) throws InterruptedException, E {
        Template.doOnSupplied(handler, this.pool, this.nrImmediateRetries, this.retryWaitMillis, this.timeout);
    }

    public static <T, E extends Exception> void doOnSupplied(final Handler<T, E> handler, final RecyclingSupplier<T> pool, int nrImmediateRetries, int retryWaitMillis, int timeoutMillis) throws E, InterruptedException {
        Callables.executeWithRetry(new Callables.TimeoutCallable<Void, E>(timeoutMillis){

            @Override
            public Void call(long deadline) throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException, Exception {
                Template.doOnSupplied(handler, pool, deadline);
                return null;
            }
        }, nrImmediateRetries, retryWaitMillis);
    }

    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"})
    private static <T, E extends Exception> void doOnSupplied(Handler<T, E> handler, RecyclingSupplier<T> pool, long deadline) throws E, ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException {
        T object = pool.get();
        try {
            handler.handle(object, deadline);
        }
        catch (Exception e) {
            try {
                pool.recycle(object, e);
            }
            catch (RuntimeException ex) {
                throw Throwables.suppress(ex, e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw e;
        }
        pool.recycle(object, null);
    }

    public String toString() {
        return "Template{pool=" + this.pool + ", nrImmediateRetries=" + this.nrImmediateRetries + ", retryWaitMillis=" + this.retryWaitMillis + ", timeout=" + this.timeout + '}';
    }
}

