/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.base.SysExits;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;

public final class OpenFilesSampler {
    private static ScheduledFuture<?> samplingFuture;
    private static AccumulatorRunnable accumulator;
    private static final Logger LOG;
    private static volatile String lastWarnLsof;

    private OpenFilesSampler() {
    }

    public static void start(long sampleTimeMillis) {
        OpenFilesSampler.start(sampleTimeMillis, Runtime.Ulimit.MAX_NR_OPENFILES - Runtime.Ulimit.MAX_NR_OPENFILES / 10, Runtime.Ulimit.MAX_NR_OPENFILES, true);
    }

    @JmxExport
    public static void start(@JmxExport(value="sampleTimeMillis") long sampleTimeMillis, @JmxExport(value="shutdownOnError") boolean shutdownOnError) {
        OpenFilesSampler.start(sampleTimeMillis, Runtime.Ulimit.MAX_NR_OPENFILES - Runtime.Ulimit.MAX_NR_OPENFILES / 10, Runtime.Ulimit.MAX_NR_OPENFILES, shutdownOnError);
    }

    @JmxExport
    public static String getWarnLsofDetail() {
        return lastWarnLsof;
    }

    public static void start(long sampleTimeMillis, int warnThreshold, int errorThreshold, boolean shutdownOnError) {
        OpenFilesSampler.start(sampleTimeMillis, warnThreshold, errorThreshold, shutdownOnError, (int)sampleTimeMillis * 10);
    }

    public static synchronized void start(long sampleTimeMillis, int warnThreshold, int errorThreshold, boolean shutdownOnError, int aggTimeMillis) {
        if (samplingFuture != null) {
            throw new IllegalStateException("Open file usage sampling already started " + samplingFuture);
        }
        accumulator = new AccumulatorRunnable(errorThreshold, shutdownOnError, warnThreshold, aggTimeMillis);
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(accumulator, sampleTimeMillis, sampleTimeMillis, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            samplingFuture = null;
            accumulator.close();
            accumulator = null;
        }
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    @JmxExport
    public static String getLsof() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return Runtime.getLsofOutput();
    }

    static {
        LOG = LoggerFactory.getLogger(OpenFilesSampler.class);
        lastWarnLsof = "";
        Runtime.queueHook(2, new AbstractRunnable(true){

            @Override
            public void doRun() {
                OpenFilesSampler.stop();
            }
        });
        Registry.export(OpenFilesSampler.class);
    }

    private static class AccumulatorRunnable
    extends AbstractRunnable
    implements Closeable {
        private final int errorThreshold;
        private final boolean shutdownOnError;
        private final int warnThreshold;
        private final MeasurementRecorder nrOpenFiles;

        AccumulatorRunnable(int errorThreshold, boolean shutdownOnError, int warnThreshold, int aggMillis) {
            this.errorThreshold = errorThreshold;
            this.shutdownOnError = shutdownOnError;
            this.warnThreshold = warnThreshold;
            this.nrOpenFiles = RecorderFactory.createScalableMinMaxAvgRecorder("nr-open-files", "count", aggMillis);
        }

        @Override
        public void doRun() throws Exception {
            long time = System.currentTimeMillis();
            int nrOf = Runtime.getNrOpenFiles();
            if (nrOf > this.errorThreshold) {
                lastWarnLsof = Runtime.getLsofOutput();
                LOG.error("Nr open files is {} and exceeds error threshold {}, detail:\n{}", new Object[]{nrOf, this.errorThreshold, lastWarnLsof});
                if (this.shutdownOnError) {
                    Runtime.goDownWithError(null, SysExits.EX_IOERR);
                }
            } else if (nrOf > this.warnThreshold) {
                lastWarnLsof = Runtime.getLsofOutput();
                LOG.warn("Nr open files is {} and exceeds warn threshold {}, detail:\n{} ", new Object[]{nrOf, this.warnThreshold, lastWarnLsof});
                if (!Runtime.gc(60000L)) {
                    LOG.warn("Unable to trigger GC although running low on file resources");
                } else {
                    LOG.warn("gc executed nr open files reduced by {} files", (Object)(nrOf - Runtime.getNrOpenFiles()));
                }
            }
            this.nrOpenFiles.recordAt(time, nrOf);
        }

        @Override
        public void close() {
            try {
                this.nrOpenFiles.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

