/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import java.io.IOException;
import java.io.InputStream;
import org.spf4j.perf.MeasurementRecorderSource;

@CleanupObligation
public final class MeasuredInputStream
extends InputStream {
    private final InputStream is;
    private final String from;
    private final MeasurementRecorderSource recorderSource;

    public MeasuredInputStream(InputStream is, String from, MeasurementRecorderSource recorderSource) {
        this.is = is;
        this.from = from;
        this.recorderSource = recorderSource;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.is.read(b);
        this.recorderSource.getRecorder(this.from).record(result);
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.is.read(b, off, len);
        this.recorderSource.getRecorder(this.from).record(result);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        int result = this.is.read();
        if (result >= 0) {
            this.recorderSource.getRecorder(this.from).record(1L);
        }
        return result;
    }

    public String toString() {
        return "MeasuredInputStream{is=" + this.is + ", from=" + this.from + ", recorderSource=" + this.recorderSource + '}';
    }
}

