/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.spf4j.perf.MeasurementRecorderSource;

@CleanupObligation
@SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
public final class MeasuredFileOutputStream
extends FileOutputStream {
    private final Class<?> from;
    private final MeasurementRecorderSource recorderSource;
    private final File file;

    public MeasuredFileOutputStream(String name, Class<?> from, MeasurementRecorderSource recorderSource) throws FileNotFoundException {
        this(new File(name), from, recorderSource);
    }

    public MeasuredFileOutputStream(String name, boolean append, Class<?> from, MeasurementRecorderSource recorderSource) throws FileNotFoundException {
        this(new File(name), append, from, recorderSource);
    }

    public MeasuredFileOutputStream(File file, Class<?> from, MeasurementRecorderSource recorderSource) throws FileNotFoundException {
        this(file, false, from, recorderSource);
    }

    public MeasuredFileOutputStream(File file, boolean append, Class<?> from, MeasurementRecorderSource recorderSource) throws FileNotFoundException {
        super(file, append);
        this.from = from;
        this.recorderSource = recorderSource;
        this.file = file;
    }

    public MeasuredFileOutputStream(FileDescriptor fdObj, Class<?> from, MeasurementRecorderSource recorderSource) {
        super(fdObj);
        this.from = from;
        this.recorderSource = recorderSource;
        this.file = null;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.recorderSource.getRecorder(this.from).record(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.recorderSource.getRecorder(this.from).record(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.recorderSource.getRecorder(this.from).record(len);
    }

    public String toString() {
        return "MeasuredFileOutputStream{from=" + this.from + ", recorderSource=" + this.recorderSource + ", file=" + this.file + '}';
    }
}

