/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spf4j.io.Csv;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MultiMeasurementRecorder;
import org.spf4j.perf.impl.CountingAccumulator;
import org.spf4j.perf.impl.DirectRecorderSource;
import org.spf4j.perf.impl.DirectStoreAccumulator;
import org.spf4j.perf.impl.DirectStoreMultiAccumulator;
import org.spf4j.perf.impl.MeasurementsInfoImpl;
import org.spf4j.perf.impl.MinMaxAvgAccumulator;
import org.spf4j.perf.impl.QuantizedAccumulator;
import org.spf4j.perf.impl.ScalableMeasurementRecorder;
import org.spf4j.perf.impl.ScalableMeasurementRecorderSource;
import org.spf4j.perf.impl.ms.Flusher;
import org.spf4j.perf.impl.ms.MultiStore;
import org.spf4j.perf.impl.ms.StoreType;
import org.spf4j.perf.impl.ms.graphite.GraphiteTcpStore;
import org.spf4j.perf.impl.ms.graphite.GraphiteUdpStore;
import org.spf4j.perf.impl.ms.tsdb.TSDBMeasurementStore;
import org.spf4j.recyclable.ObjectCreationException;

public final class RecorderFactory {
    public static final MeasurementStore MEASUREMENT_STORE;

    private RecorderFactory() {
    }

    public static MeasurementStore getMeasurementStore() {
        return MEASUREMENT_STORE;
    }

    @Nonnull
    private static MeasurementStore buildStoreFromConfig(@Nullable String configuration) throws IOException, ObjectCreationException {
        if (configuration == null || configuration.trim().isEmpty()) {
            return new TSDBMeasurementStore(System.getProperty("spf4j.perf.ms.defaultTsdbFolderPath", System.getProperty("java.io.tmpdir")) + File.separator + System.getProperty("spf4j.perf.ms.defaultTsdbFileNamePrefix", ManagementFactory.getRuntimeMXBean().getName() + ".tsdb2"));
        }
        List<String> stores = Csv.readRow(new StringReader(configuration), new Csv.CsvRowHandler<List<String>>(){
            private final List<String> result = new ArrayList<String>(4);

            @Override
            public void element(CharSequence elem) {
                this.result.add(elem.toString());
            }

            @Override
            public List<String> eof() {
                return this.result;
            }
        });
        int size = stores.size();
        if (size == 1) {
            return RecorderFactory.fromString(stores.get(0));
        }
        MeasurementStore[] mstores = new MeasurementStore[size];
        int i = 0;
        for (String config : stores) {
            mstores[i] = RecorderFactory.fromString(config);
            ++i;
        }
        return new MultiStore(mstores);
    }

    public static MeasurementStore fromString(String string) throws IOException, ObjectCreationException {
        int atIdx = string.indexOf(64);
        int length = string.length();
        if (atIdx < 0) {
            atIdx = length;
        }
        StoreType type = StoreType.valueOf(string.substring(0, atIdx));
        if (atIdx >= length) {
            return type.create("");
        }
        return type.create(string.substring(atIdx + 1));
    }

    public static MeasurementRecorder createScalableQuantizedRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createScalableCountingRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new CountingAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createScalableMinMaxAvgRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorder mr = new ScalableMeasurementRecorder(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorderSource createScalableQuantizedRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis, int factor, int lowerMagnitude, int higherMagnitude, int quantasPerMagnitude) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new QuantizedAccumulator(forWhat, "", unitOfMeasurement, factor, lowerMagnitude, higherMagnitude, quantasPerMagnitude), sampleTimeMillis, MEASUREMENT_STORE);
        mrs.registerJmx();
        return mrs;
    }

    public static MeasurementRecorderSource createScalableCountingRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new CountingAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mrs.registerJmx();
        return mrs;
    }

    public static MeasurementRecorderSource createScalableMinMaxAvgRecorderSource(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        ScalableMeasurementRecorderSource mrs = new ScalableMeasurementRecorderSource(new MinMaxAvgAccumulator(forWhat, "", unitOfMeasurement), sampleTimeMillis, MEASUREMENT_STORE);
        mrs.registerJmx();
        return mrs;
    }

    public static MultiMeasurementRecorder createDirectRecorder(Object measuredEntity, String description, String[] measurementNames, String[] measurementUnits) {
        DirectStoreMultiAccumulator mr = new DirectStoreMultiAccumulator(new MeasurementsInfoImpl(measuredEntity, description, measurementNames, measurementUnits), MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectRecorder(Object forWhat, String unitOfMeasurement, int sampleTimeMillis) {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, sampleTimeMillis, MEASUREMENT_STORE);
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorderSource createDirectRecorderSource(Object forWhat, String unitOfMeasurement) {
        return new DirectRecorderSource(forWhat, "", unitOfMeasurement, 0, MEASUREMENT_STORE);
    }

    public static MeasurementRecorder createDirectGraphiteUdpRecorder(Object forWhat, String unitOfMeasurement, String graphiteHost, int graphitePort) throws ObjectCreationException {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, new GraphiteUdpStore(graphiteHost, graphitePort));
        mr.registerJmx();
        return mr;
    }

    public static MeasurementRecorder createDirectGraphiteTcpRecorder(Object forWhat, String unitOfMeasurement, String graphiteHost, int graphitePort) throws ObjectCreationException {
        DirectStoreAccumulator mr = new DirectStoreAccumulator(forWhat, "", unitOfMeasurement, 0, new GraphiteTcpStore(graphiteHost, graphitePort));
        mr.registerJmx();
        return mr;
    }

    static {
        try {
            MEASUREMENT_STORE = RecorderFactory.buildStoreFromConfig(System.getProperty("spf4j.perf.ms.config", null));
            Flusher.flushEvery(Integer.getInteger("spf4j.perf.ms.flushIntervalMillis", 60000), MEASUREMENT_STORE);
        }
        catch (IOException | ObjectCreationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

