/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.spf4j.base.Pair;
import org.spf4j.concurrent.UnboundedLoadingCache;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.impl.DirectStoreAccumulator;

public final class DirectRecorderSource
implements MeasurementRecorderSource {
    private final LoadingCache<Object, MeasurementRecorder> recorders;

    public DirectRecorderSource(Object forWhat, String description, String uom, int sampleTimeMillis, MeasurementStore store) {
        this.recorders = new UnboundedLoadingCache<Object, MeasurementRecorder>(16, new CreateDirectRecorder(forWhat, description, uom, sampleTimeMillis, store));
    }

    @Override
    public MeasurementRecorder getRecorder(Object forWhat) {
        return (MeasurementRecorder)this.recorders.getUnchecked(forWhat);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "DirectRecorderSource{recorders=" + this.recorders + '}';
    }

    private static final class CreateDirectRecorder
    extends CacheLoader<Object, MeasurementRecorder> {
        private final Object forWhat;
        private final String description;
        private final String uom;
        private final int sampleTimeMillis;
        private final MeasurementStore store;

        CreateDirectRecorder(Object forWhat, String description, String uom, int sampleTimeMillis, MeasurementStore store) {
            this.forWhat = forWhat;
            this.description = description;
            this.uom = uom;
            this.sampleTimeMillis = sampleTimeMillis;
            this.store = store;
        }

        public MeasurementRecorder load(Object key) {
            return new DirectStoreAccumulator(Pair.of(this.forWhat, key), this.description, this.uom, this.sampleTimeMillis, this.store);
        }
    }
}

