/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.cpu;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.stackmonitor.FastStackCollector;

public final class ThreadUsageSampler {
    private static final ThreadMXBean TH_BEAN = ManagementFactory.getThreadMXBean();
    private static ScheduledFuture<?> samplingFuture;
    private static final List<String> PEAK_THREAD_NAMES;
    private static final List<StackTraceElement[]> PEAK_THREAD_TRACES;
    private static final BitSet PEAK_THREAD_DAEMON;

    private ThreadUsageSampler() {
    }

    public static void writePeakThreadInfo(PrintStream out) {
        out.println("Peak Threads:");
        int i = 0;
        boolean haveStacktraces = PEAK_THREAD_TRACES.size() > 0;
        for (String tname : PEAK_THREAD_NAMES) {
            out.print(tname);
            out.print(", daemon =");
            out.print(PEAK_THREAD_DAEMON.get(i));
            out.print(',');
            if (haveStacktraces) {
                out.print(' ');
                out.print(Arrays.toString(PEAK_THREAD_TRACES.get(i)));
            }
            out.println();
            ++i;
        }
    }

    @JmxExport
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING", "NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static String getPeakThreadInfo() {
        try (ByteArrayBuilder bab = new ByteArrayBuilder();){
            PrintStream ps = new PrintStream(bab);
            ThreadUsageSampler.writePeakThreadInfo(ps);
            String string = bab.toString(Charset.defaultCharset());
            return string;
        }
    }

    @JmxExport
    public static String getCurrentAliveThreadInfo() {
        StringBuilder sb = new StringBuilder(1024);
        Thread[] threads = FastStackCollector.getThreads();
        StackTraceElement[][] stackTraces = FastStackCollector.getStackTraces(threads);
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            if (!t.isAlive()) continue;
            sb.append(t.getName());
            sb.append(", daemon =");
            sb.append(t.isDaemon());
            sb.append(',');
            Object[] straces = stackTraces[i];
            if (straces != null && straces.length > 0) {
                sb.append(' ');
                sb.append(Arrays.toString(straces));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static synchronized void start(int sampleTime) {
        ThreadUsageSampler.start(sampleTime, true);
    }

    @JmxExport
    public static synchronized void start(@JmxExport(value="sampleTimeMillis") int sampleTime, final @JmxExport(value="withStackTraces") boolean withStackTraces) {
        if (samplingFuture != null) {
            throw new IllegalStateException("Thread sampling already started " + samplingFuture);
        }
        final MeasurementRecorder cpuUsage = RecorderFactory.createDirectRecorder("peak-thread-count", "count", sampleTime);
        samplingFuture = DefaultScheduler.INSTANCE.scheduleWithFixedDelay(new AbstractRunnable(){
            private int maxThreadsNr = 0;

            @Override
            public void doRun() {
                int peakThreadCount = TH_BEAN.getPeakThreadCount();
                cpuUsage.record(peakThreadCount);
                if (peakThreadCount > this.maxThreadsNr) {
                    Thread[] ths = FastStackCollector.getThreads();
                    if (ths.length > PEAK_THREAD_NAMES.size()) {
                        if (withStackTraces) {
                            StackTraceElement[][] stackTraces = FastStackCollector.getStackTraces(ths);
                            PEAK_THREAD_TRACES.clear();
                            PEAK_THREAD_TRACES.addAll(Arrays.asList(stackTraces));
                        }
                        PEAK_THREAD_NAMES.clear();
                        int i = 0;
                        for (Thread th : ths) {
                            PEAK_THREAD_NAMES.add(th.getName());
                            if (th.isDaemon()) {
                                PEAK_THREAD_DAEMON.set(i);
                            } else {
                                PEAK_THREAD_DAEMON.clear(i);
                            }
                            ++i;
                        }
                    }
                    this.maxThreadsNr = peakThreadCount;
                }
                TH_BEAN.resetPeakThreadCount();
            }
        }, sampleTime, sampleTime, TimeUnit.MILLISECONDS);
    }

    @JmxExport
    public static synchronized void stop() {
        if (samplingFuture != null) {
            samplingFuture.cancel(false);
            samplingFuture = null;
        }
    }

    @JmxExport
    public static synchronized boolean isStarted() {
        return samplingFuture != null;
    }

    static {
        PEAK_THREAD_NAMES = new ArrayList<String>();
        PEAK_THREAD_TRACES = new ArrayList<StackTraceElement[]>();
        PEAK_THREAD_DAEMON = new BitSet();
        Runtime.queueHook(2, new AbstractRunnable(true){

            @Override
            public void doRun() {
                ThreadUsageSampler.stop();
                ThreadUsageSampler.writePeakThreadInfo(System.err);
            }
        });
        Registry.export(ThreadUsageSampler.class);
    }
}

