/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.MBeanParameterInfo;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.JmxExport;

final class ExportedOperationImpl
implements ExportedOperation {
    private final String name;
    private final String description;
    private final Method method;
    private final Object object;
    private final MBeanParameterInfo[] paramInfos;

    ExportedOperationImpl(String name, String description, Method method, Object object) {
        this.name = name;
        this.description = description;
        this.method = method;
        this.object = object;
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        this.paramInfos = new MBeanParameterInfo[parameterTypes.length];
        for (int i = 0; i < this.paramInfos.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            String pname = "";
            String pdesc = "";
            for (Annotation annot : annotations) {
                if (annot.annotationType() != JmxExport.class) continue;
                JmxExport eAnn = (JmxExport)annot;
                pname = eAnn.value();
                pdesc = eAnn.description();
                break;
            }
            if ("".equals(pname)) {
                pname = "param_" + i;
            }
            this.paramInfos[i] = new MBeanParameterInfo(pname, parameterTypes[i].getName(), pdesc);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public Object invoke(Object[] parameters) {
        try {
            return this.method.invoke(this.object, parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MBeanParameterInfo[] getParameterInfos() {
        return this.paramInfos;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public String toString() {
        return "ExportedOperationImpl{name=" + this.name + ", description=" + this.description + ", method=" + this.method + ", object=" + this.object + ", paramInfos=" + Arrays.toString(this.paramInfos) + '}';
    }
}

