/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.tcp.proxy;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Closeables;
import org.spf4j.ds.UpdateablePriorityQueue;
import org.spf4j.io.tcp.ClientHandler;
import org.spf4j.io.tcp.DeadlineAction;
import org.spf4j.io.tcp.proxy.ProxyBufferTransferHandler;
import org.spf4j.io.tcp.proxy.SnifferFactory;
import org.spf4j.io.tcp.proxy.TransferBuffer;

@ParametersAreNonnullByDefault
public final class ProxyClientHandler
implements ClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyClientHandler.class);
    private final HostAndPort fwdDestination;
    private final int proxyBufferSize;
    private final int connectTimeoutMillis;
    private final SnifferFactory c2sSnifferFact;
    private final SnifferFactory s2cSnifferFact;

    public ProxyClientHandler(HostAndPort fwdDestination, @Nullable SnifferFactory c2sSnifferFact, @Nullable SnifferFactory s2cSnifferFact, int proxyBufferSize, int connectTimeoutMillis) {
        this.fwdDestination = fwdDestination;
        this.proxyBufferSize = proxyBufferSize;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.c2sSnifferFact = c2sSnifferFact;
        this.s2cSnifferFact = s2cSnifferFact;
    }

    @Override
    public void handle(Selector serverSelector, SocketChannel clientChannel, ExecutorService exec, BlockingQueue<Runnable> tasksToRunBySelector, UpdateablePriorityQueue<DeadlineAction> deadlineActions) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(this.fwdDestination.getHostText(), this.fwdDestination.getPort());
        SocketChannel proxyChannel = SocketChannel.open();
        try {
            proxyChannel.configureBlocking(false);
            proxyChannel.connect(socketAddress);
            TransferBuffer c2s = new TransferBuffer(this.proxyBufferSize);
            if (this.c2sSnifferFact != null) {
                c2s.setIncomingSniffer(this.c2sSnifferFact.get(clientChannel));
            }
            TransferBuffer s2c = new TransferBuffer(this.proxyBufferSize);
            long connectDeadline = System.currentTimeMillis() + (long)this.connectTimeoutMillis;
            UpdateablePriorityQueue.ElementRef daction = deadlineActions.add(new DeadlineAction(connectDeadline, new CloseChannelsOnTimeout(proxyChannel, clientChannel)));
            new ProxyBufferTransferHandler(c2s, s2c, null, clientChannel, serverSelector, exec, tasksToRunBySelector, daction).initialInterestRegistration();
            new ProxyBufferTransferHandler(s2c, c2s, this.s2cSnifferFact, proxyChannel, serverSelector, exec, tasksToRunBySelector, daction).initialInterestRegistration();
        }
        catch (IOException ex) {
            Exception exs = Closeables.closeAll(proxyChannel, clientChannel);
            ex.addSuppressed(exs);
            throw ex;
        }
    }

    public String toString() {
        return "ProxyClientHandler{fwdDestination=" + this.fwdDestination + ", proxyBufferSize=" + this.proxyBufferSize + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", c2sSnifferFact=" + this.c2sSnifferFact + ", s2cSnifferFact=" + this.s2cSnifferFact + '}';
    }

    static final class CloseChannelsOnTimeout
    extends AbstractRunnable {
        private final SocketChannel proxyChannel;
        private final SocketChannel clientChannel;

        CloseChannelsOnTimeout(SocketChannel proxyChannel, SocketChannel clientChannel) {
            super(true);
            this.proxyChannel = proxyChannel;
            this.clientChannel = clientChannel;
        }

        @Override
        public void doRun() throws IOException {
            LOG.warn("Timed out connecting to {}", (Object)this.proxyChannel);
            try {
                this.clientChannel.close();
            }
            finally {
                this.proxyChannel.close();
            }
        }
    }
}

