/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.tcp.proxy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.ds.UpdateablePriorityQueue;
import org.spf4j.io.tcp.SelectorEventHandler;
import org.spf4j.io.tcp.proxy.SnifferFactory;
import org.spf4j.io.tcp.proxy.TransferBuffer;

@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"HES_EXECUTOR_NEVER_SHUTDOWN"})
public final class ProxyBufferTransferHandler
extends SelectorEventHandler {
    private final SocketChannel channel;
    private final Selector selector;
    private final UpdateablePriorityQueue.ElementRef deadlineActionRef;
    private volatile boolean connected;
    private final ExecutorService exec;
    private final Runnable readRun;
    private final Runnable writeRun;
    private final SnifferFactory snifferFactory;
    private final TransferBuffer in;
    private final TransferBuffer out;
    private final BlockingQueue<Runnable> tasksToRunBySelector;
    private static final Logger LOG = LoggerFactory.getLogger(ProxyBufferTransferHandler.class);

    public ProxyBufferTransferHandler(TransferBuffer in, TransferBuffer out, @Nullable SnifferFactory snifferFactory, SocketChannel channel, Selector selector, ExecutorService exec, BlockingQueue<Runnable> tasksToRunBySelector, UpdateablePriorityQueue.ElementRef deadlineActionRef) {
        this.in = in;
        this.out = out;
        this.exec = exec;
        this.channel = channel;
        this.selector = selector;
        this.deadlineActionRef = deadlineActionRef;
        this.connected = channel.isConnected();
        this.snifferFactory = snifferFactory;
        this.tasksToRunBySelector = tasksToRunBySelector;
        this.readRun = new ReadFromChannel(in, channel);
        this.writeRun = new WriteToChannel(out, channel);
    }

    @Override
    public SelectionKey initialInterestRegistration() throws ClosedChannelException {
        SelectionKey tkey = this.channel.register(this.selector, 9, this);
        ReadInterest readInterest = new ReadInterest(tkey);
        WriteInterest writeInterest = new WriteInterest(tkey);
        this.out.setIsDataInBufferHook(new DataAvailableToWriteHook(this.tasksToRunBySelector, writeInterest, this.selector));
        this.in.setIsRoomInBufferHook(new RoomToReadHook(this.tasksToRunBySelector, readInterest, this.selector));
        return tkey;
    }

    @Override
    public boolean canRunAsync() {
        return true;
    }

    @Override
    public synchronized void runAsync(SelectionKey sKey) throws IOException {
        if (!this.connected && sKey.isConnectable()) {
            sKey.interestOps(sKey.interestOps() & 0xFFFFFFF7);
            this.connected = this.channel.finishConnect();
            if (this.connected) {
                LOG.debug("Connected to {}", (Object)this.channel);
                this.deadlineActionRef.remove();
                if (this.snifferFactory != null) {
                    this.in.setIncomingSniffer(this.snifferFactory.get(this.channel));
                }
            }
        }
        if (this.connected) {
            if (sKey.isReadable()) {
                this.exec.execute(this.readRun);
                sKey.interestOps(sKey.interestOps() & 0xFFFFFFFE);
            }
            if (sKey.isWritable()) {
                this.exec.execute(this.writeRun);
                sKey.interestOps(sKey.interestOps() & 0xFFFFFFFB);
            }
        }
    }

    @Override
    public void run(SelectionKey skey) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ProxyBufferTransferHandler{channel=" + this.channel + ", selector=" + this.selector + ", connected=" + this.connected + ", in=" + this.in + ", out=" + this.out + '}';
    }

    private static class WriteToChannel
    extends AbstractRunnable {
        private final TransferBuffer out;
        private final SocketChannel channel;

        WriteToChannel(TransferBuffer out, SocketChannel channel) {
            super(true);
            this.out = out;
            this.channel = channel;
        }

        @Override
        public void doRun() {
            int written = this.out.write(this.channel);
            LOG.debug("Written {} bytes to {}", (Object)written, (Object)this.channel);
        }
    }

    private static class ReadFromChannel
    extends AbstractRunnable {
        private final TransferBuffer in;
        private final SocketChannel channel;

        ReadFromChannel(TransferBuffer in, SocketChannel channel) {
            super(true);
            this.in = in;
            this.channel = channel;
        }

        @Override
        public void doRun() {
            int read = this.in.read(this.channel);
            LOG.debug("Read {} bytes from {}", (Object)read, (Object)this.channel);
        }
    }

    private static class RoomToReadHook
    extends AbstractRunnable {
        private final BlockingQueue<Runnable> tasksToRunBySelector;
        private final ReadInterest readInterest;
        private final Selector selector;

        RoomToReadHook(BlockingQueue<Runnable> tasksToRunBySelector, ReadInterest readInterest, Selector selector) {
            super(false);
            this.tasksToRunBySelector = tasksToRunBySelector;
            this.readInterest = readInterest;
            this.selector = selector;
        }

        @Override
        public void doRun() throws InterruptedException {
            this.tasksToRunBySelector.put(this.readInterest);
            this.selector.wakeup();
        }
    }

    private static class DataAvailableToWriteHook
    extends AbstractRunnable {
        private final BlockingQueue<Runnable> tasksToRunBySelector;
        private final WriteInterest writeInterest;
        private final Selector selector;

        DataAvailableToWriteHook(BlockingQueue<Runnable> tasksToRunBySelector, WriteInterest writeInterest, Selector selector) {
            super(false);
            this.tasksToRunBySelector = tasksToRunBySelector;
            this.writeInterest = writeInterest;
            this.selector = selector;
        }

        @Override
        public void doRun() throws InterruptedException {
            this.tasksToRunBySelector.put(this.writeInterest);
            this.selector.wakeup();
        }
    }

    private static class WriteInterest
    implements Runnable {
        private final SelectionKey tKey;

        WriteInterest(SelectionKey key) {
            this.tKey = key;
        }

        @Override
        public void run() {
            this.tKey.interestOps(this.tKey.interestOps() | 4);
        }
    }

    private static class ReadInterest
    implements Runnable {
        private final SelectionKey tKey;

        ReadInterest(SelectionKey key) {
            this.tKey = key;
        }

        @Override
        public void run() {
            this.tKey.interestOps(this.tKey.interestOps() | 1);
        }
    }
}

