/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.tcp;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.ds.UpdateablePriorityQueue;
import org.spf4j.io.tcp.ClientHandler;
import org.spf4j.io.tcp.DeadlineAction;
import org.spf4j.io.tcp.SelectorEventHandler;

@SuppressFBWarnings(value={"HES_EXECUTOR_NEVER_SHUTDOWN"})
public final class AcceptorSelectorEventHandler
extends SelectorEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AcceptorSelectorEventHandler.class);
    private final ClientHandler clientHandler;
    private final ServerSocketChannel serverChannel;
    private final Selector selector;
    private final ExecutorService exec;
    private final BlockingQueue<Runnable> tasksToRunBySelector;
    private final UpdateablePriorityQueue<DeadlineAction> deadlineActions;

    public AcceptorSelectorEventHandler(ServerSocketChannel channel, ClientHandler clientHandler, Selector selector, ExecutorService exec, BlockingQueue<Runnable> tasksToRunBySelector, UpdateablePriorityQueue<DeadlineAction> deadlineActions) {
        this.serverChannel = channel;
        this.clientHandler = clientHandler;
        this.selector = selector;
        this.exec = exec;
        this.tasksToRunBySelector = tasksToRunBySelector;
        this.deadlineActions = deadlineActions;
    }

    @Override
    public void run(SelectionKey key) throws IOException {
        SocketChannel clientChannel;
        if (!key.isAcceptable()) {
            throw new IllegalStateException("selection key must be acceptable " + key);
        }
        while ((clientChannel = this.serverChannel.accept()) != null) {
            try {
                LOG.debug("Accepted {}", (Object)clientChannel);
                clientChannel.configureBlocking(false);
                this.clientHandler.handle(this.selector, clientChannel, this.exec, this.tasksToRunBySelector, this.deadlineActions);
            }
            catch (IOException ex) {
                clientChannel.close();
                throw ex;
            }
        }
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public void runAsync(SelectionKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectionKey initialInterestRegistration() throws ClosedChannelException {
        return this.serverChannel.register(this.selector, 16, this);
    }

    public String toString() {
        return "AcceptorSelectorEventHandler{clientHandler=" + this.clientHandler + ", serverChannel=" + this.serverChannel + ", selector=" + this.selector + ", exec=" + this.exec + ", tasksToRunBySelector=" + this.tasksToRunBySelector + ", deadlineActions=" + this.deadlineActions + '}';
    }
}

