/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.spf4j.io.AppendableOutputStream;

@CleanupObligation
public final class WriterOutputStream
extends AppendableOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Writer writer;

    public WriterOutputStream(Writer writer, CharsetDecoder decoder) {
        this(writer, decoder, 8192);
    }

    public WriterOutputStream(Writer writer, CharsetDecoder decoder, int bufferSize) {
        super((Appendable)writer, decoder, bufferSize);
        this.writer = writer;
    }

    public WriterOutputStream(Writer writer, Charset charset, int bufferSize) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), bufferSize);
    }

    public WriterOutputStream(Writer writer, Charset charset) {
        this(writer, charset, 8192);
    }

    public WriterOutputStream(Writer writer, String charsetName, int bufferSize) {
        this(writer, Charset.forName(charsetName), bufferSize);
    }

    public WriterOutputStream(Writer writer, String charsetName) {
        this(writer, charsetName, 8192);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.writer.flush();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        super.close();
        this.writer.close();
    }

    @Override
    protected void flushOutput() throws IOException {
        if (this.decoderOut.position() > 0) {
            this.writer.write(this.decoderOut.array(), 0, this.decoderOut.position());
            this.decoderOut.rewind();
        }
    }

    @Override
    public String toString() {
        return "WriterOutputStream{writer=" + this.writer + '}';
    }
}

