/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

@CleanupObligation
public final class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size " + size + " <= 0");
        }
        this.buf = new char[size];
        this.pos = size;
    }

    public PushbackReader(Reader in) {
        this(in, 1);
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed " + this);
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++];
        }
        return super.read();
    }

    @Override
    public int read(char[] cbuf, int poff, int plen) throws IOException {
        int off = poff;
        int len = plen;
        this.ensureOpen();
        if (len <= 0) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("len = " + len);
            }
            if (off < 0 || off > cbuf.length) {
                throw new IndexOutOfBoundsException("off = " + off);
            }
            return 0;
        }
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (len < avail) {
                avail = len;
            }
            System.arraycopy(this.buf, this.pos, cbuf, off, avail);
            this.pos += avail;
            off += avail;
            len -= avail;
        }
        if (len > 0) {
            if ((len = super.read(cbuf, off, len)) == -1) {
                return avail == 0 ? -1 : avail;
            }
            return avail + len;
        }
        return avail;
    }

    public void unread(int c) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Pushback buffer overflow " + this);
        }
        if (c < 0) {
            throw new IllegalArgumentException("pushing back invalid character " + c);
        }
        this.buf[--this.pos] = (char)c;
    }

    public void unread(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (len > this.pos) {
            throw new IOException("Pushback buffer overflow " + this);
        }
        this.pos -= len;
        System.arraycopy(cbuf, off, this.buf, this.pos, len);
    }

    public void unread(char[] cbuf) throws IOException {
        this.unread(cbuf, 0, cbuf.length);
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.buf.length || super.ready();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported " + this);
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported " + this);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        super.close();
        this.buf = null;
    }

    @Override
    public long skip(long pn) throws IOException {
        long n = pn;
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative " + pn);
        }
        this.ensureOpen();
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (n <= (long)avail) {
                this.pos = (int)((long)this.pos + n);
                return n;
            }
            this.pos = this.buf.length;
            n -= (long)avail;
        }
        return (long)avail + super.skip(n);
    }

    public String toString() {
        return "PushbackReader{buf=" + new String(this.buf) + ", pos=" + this.pos + ", wrapped=" + this.in + '}';
    }
}

