/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.io.BaseEncoding;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.base.Runtime;
import org.spf4j.io.EmptyInputStream;
import org.spf4j.io.IOTimeoutException;
import org.spf4j.recyclable.SizedRecyclingSupplier;
import org.spf4j.recyclable.impl.ArraySuppliers;

@CleanupObligation
@ThreadSafe
public final class PipedOutputStream
extends OutputStream {
    private byte[] buffer;
    private final Object sync = new Object();
    private int startIdx;
    private int endIdx;
    private int readerPerceivedEndIdx;
    private boolean writerClosed;
    private int nrReadStreams;
    private final SizedRecyclingSupplier<byte[]> bufferProvider;
    private final Long globalDeadline;

    public PipedOutputStream() {
        this(8192);
    }

    public PipedOutputStream(int bufferSize) {
        this(bufferSize, ArraySuppliers.Bytes.JAVA_NEW);
    }

    public PipedOutputStream(int bufferSize, long globalDeadline) {
        this(bufferSize, ArraySuppliers.Bytes.JAVA_NEW, globalDeadline);
    }

    public PipedOutputStream(int bufferSize, SizedRecyclingSupplier<byte[]> bufferProvider) {
        this(bufferSize, bufferProvider, null);
    }

    public PipedOutputStream(int bufferSize, SizedRecyclingSupplier<byte[]> bufferProvider, @Nullable Long globalDeadline) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("Illegal buffer size " + bufferSize);
        }
        this.bufferProvider = bufferProvider;
        this.buffer = bufferProvider.get(bufferSize);
        this.startIdx = 0;
        this.endIdx = 0;
        this.readerPerceivedEndIdx = 0;
        this.writerClosed = false;
        this.nrReadStreams = 0;
        this.globalDeadline = globalDeadline;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long deadline = this.getDeadline();
        this.writeUntil(b, off, len, deadline);
    }

    public long getDeadline() {
        if (this.globalDeadline == null) {
            return Runtime.getDeadline();
        }
        return this.globalDeadline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUntil(byte[] b, int off, int len, long deadline) throws IOException {
        int bytesWritten = 0;
        while (bytesWritten < len) {
            Object object = this.sync;
            synchronized (object) {
                int a2w = 0;
                while (!this.writerClosed && this.nrReadStreams > 0 && (a2w = this.availableToWrite()) < 1) {
                    long timeToWait = deadline - System.currentTimeMillis();
                    if (timeToWait <= 0L) {
                        throw new IOTimeoutException(deadline, -timeToWait);
                    }
                    try {
                        this.sync.wait(timeToWait);
                    }
                    catch (InterruptedException ex) {
                        throw new IOException("Interrupted while writing " + Arrays.toString(b), ex);
                    }
                }
                if (this.writerClosed) {
                    throw new IOException("Cannot write, stream closed " + this);
                }
                if (this.nrReadStreams <= 0) {
                    throw new IOException("Broken pipe " + this);
                }
                a2w = Math.min(a2w, len - bytesWritten);
                int wrToEnd = Math.min(a2w, this.buffer.length - this.endIdx);
                System.arraycopy(b, off + bytesWritten, this.buffer, this.endIdx, wrToEnd);
                this.endIdx += wrToEnd;
                bytesWritten += wrToEnd;
                int wrapArround = a2w - wrToEnd;
                if (wrapArround > 0) {
                    System.arraycopy(b, off + bytesWritten, this.buffer, 0, wrapArround);
                    this.endIdx = wrapArround;
                    bytesWritten += wrapArround;
                } else if (this.endIdx >= this.buffer.length) {
                    this.endIdx = 0;
                }
                if (this.availableToWrite() < 1) {
                    this.flush();
                }
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        long deadline = this.getDeadline();
        this.writeUntil(b, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUntil(int b, long deadline) throws IOException {
        Object object = this.sync;
        synchronized (object) {
            int a2w = 0;
            while (!this.writerClosed && this.nrReadStreams > 0 && (a2w = this.availableToWrite()) < 1) {
                try {
                    long timeToWait = deadline - System.currentTimeMillis();
                    if (timeToWait <= 0L) {
                        throw new IOTimeoutException(deadline, -timeToWait);
                    }
                    this.sync.wait(timeToWait);
                }
                catch (InterruptedException ex) {
                    throw new IOException("Interrupted while writing " + b, ex);
                }
            }
            if (this.writerClosed) {
                throw new IOException("Cannot write stream closed " + this);
            }
            if (this.nrReadStreams <= 0) {
                throw new IOException("Broken pipe " + this);
            }
            this.buffer[this.endIdx++] = (byte)b;
            if (this.endIdx >= this.buffer.length) {
                this.endIdx = 0;
            }
            if (a2w < 2) {
                this.flush();
            }
        }
    }

    private int availableToWrite() {
        if (this.startIdx <= this.endIdx) {
            return this.startIdx + this.buffer.length - this.endIdx - 1;
        }
        return this.startIdx - this.endIdx - 1;
    }

    private int availableToRead() {
        if (this.startIdx <= this.readerPerceivedEndIdx) {
            return this.readerPerceivedEndIdx - this.startIdx;
        }
        return this.buffer.length - this.startIdx + this.readerPerceivedEndIdx;
    }

    private int contentInBuffer() {
        if (this.startIdx <= this.endIdx) {
            return this.endIdx - this.startIdx;
        }
        return this.buffer.length - this.startIdx + this.endIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.sync;
        synchronized (object) {
            if (this.readerPerceivedEndIdx != this.endIdx) {
                this.readerPerceivedEndIdx = this.endIdx;
                this.sync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    public void close() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.writerClosed) {
                try {
                    this.writerClosed = true;
                    this.flush();
                }
                finally {
                    if (this.nrReadStreams == 0 && this.availableToRead() == 0) {
                        this.bufferProvider.recycle(this.buffer);
                        this.buffer = null;
                    }
                    this.sync.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        Object object = this.sync;
        synchronized (object) {
            if (this.writerClosed && this.availableToRead() == 0) {
                return EmptyInputStream.EMPTY;
            }
            ++this.nrReadStreams;
            return new InputStream(){
                private boolean readerClosed = false;

                @Override
                public int read() throws IOException {
                    long deadline = PipedOutputStream.this.getDeadline();
                    return this.readUntil(deadline);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int readUntil(long deadline) throws IOException {
                    Object object = PipedOutputStream.this.sync;
                    synchronized (object) {
                        int availableToRead = 0;
                        while (!this.readerClosed && (availableToRead = PipedOutputStream.this.availableToRead()) < 1 && !PipedOutputStream.this.writerClosed) {
                            long timeToWait = deadline - System.currentTimeMillis();
                            if (timeToWait <= 0L) {
                                throw new IOTimeoutException(deadline, -timeToWait);
                            }
                            try {
                                PipedOutputStream.this.sync.wait(timeToWait);
                            }
                            catch (InterruptedException ex) {
                                throw new IOException("Interrupted while reading from " + PipedOutputStream.this, ex);
                            }
                        }
                        if (this.readerClosed) {
                            throw new IOException("Reader is closed for " + PipedOutputStream.this);
                        }
                        if (availableToRead == 0) {
                            if (!PipedOutputStream.this.writerClosed) {
                                throw new IllegalStateException("Stream must be closed " + PipedOutputStream.this);
                            }
                            return -1;
                        }
                        byte result = PipedOutputStream.this.buffer[PipedOutputStream.this.startIdx];
                        PipedOutputStream.this.startIdx++;
                        if (PipedOutputStream.this.startIdx >= PipedOutputStream.this.buffer.length) {
                            PipedOutputStream.this.startIdx = 0;
                        }
                        PipedOutputStream.this.sync.notifyAll();
                        return result;
                    }
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    long deadline = PipedOutputStream.this.getDeadline();
                    return this.readUntil(len, b, off, deadline);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int readUntil(int len, byte[] b, int off, long deadline) throws IOException {
                    int bytesWritten = 0;
                    Object object = PipedOutputStream.this.sync;
                    synchronized (object) {
                        int availableToRead = 0;
                        while (!this.readerClosed && (availableToRead = PipedOutputStream.this.availableToRead()) < 1 && !PipedOutputStream.this.writerClosed) {
                            long timeToWait = deadline - System.currentTimeMillis();
                            if (timeToWait <= 0L) {
                                throw new IOTimeoutException(deadline, -timeToWait);
                            }
                            try {
                                PipedOutputStream.this.sync.wait(timeToWait);
                            }
                            catch (InterruptedException ex) {
                                throw new IOException("Interrupted while reading from " + PipedOutputStream.this, ex);
                            }
                        }
                        if (this.readerClosed) {
                            throw new IOException("Reader is closed for " + PipedOutputStream.this);
                        }
                        if (availableToRead == 0) {
                            if (!PipedOutputStream.this.writerClosed) {
                                throw new IllegalStateException("Stream should be closed, " + PipedOutputStream.this);
                            }
                            return -1;
                        }
                        availableToRead = Math.min(availableToRead, len);
                        int readToEnd = Math.min(availableToRead, PipedOutputStream.this.buffer.length - PipedOutputStream.this.startIdx);
                        System.arraycopy(PipedOutputStream.this.buffer, PipedOutputStream.this.startIdx, b, off, readToEnd);
                        bytesWritten += readToEnd;
                        PipedOutputStream.this.startIdx = PipedOutputStream.this.startIdx + readToEnd;
                        int remaining = availableToRead - readToEnd;
                        if (remaining > 0) {
                            System.arraycopy(PipedOutputStream.this.buffer, 0, b, off + readToEnd, remaining);
                            bytesWritten += remaining;
                            PipedOutputStream.this.startIdx = remaining;
                        } else if (PipedOutputStream.this.startIdx >= PipedOutputStream.this.buffer.length) {
                            PipedOutputStream.this.startIdx = 0;
                        }
                        PipedOutputStream.this.sync.notifyAll();
                        return bytesWritten;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int available() {
                    Object object = PipedOutputStream.this.sync;
                    synchronized (object) {
                        return PipedOutputStream.this.availableToRead();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    Object object = PipedOutputStream.this.sync;
                    synchronized (object) {
                        PipedOutputStream.this.nrReadStreams--;
                        this.readerClosed = true;
                        if (PipedOutputStream.this.writerClosed && PipedOutputStream.this.nrReadStreams == 0 && PipedOutputStream.this.availableToRead() == 0) {
                            PipedOutputStream.this.bufferProvider.recycle(PipedOutputStream.this.buffer);
                            PipedOutputStream.access$302(PipedOutputStream.this, null);
                        }
                        PipedOutputStream.this.sync.notifyAll();
                    }
                }
            };
        }
    }

    public synchronized byte[] getUnreadBytesFromBuffer() {
        int size = this.contentInBuffer();
        if (size == 0) {
            return org.spf4j.base.Arrays.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[size];
        if (this.startIdx < this.endIdx) {
            System.arraycopy(this.buffer, this.startIdx, result, 0, result.length);
        } else {
            int toEnd = this.buffer.length - this.startIdx;
            System.arraycopy(this.buffer, this.startIdx, result, 0, toEnd);
            System.arraycopy(this.buffer, 0, result, toEnd, this.endIdx);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.sync;
        synchronized (object) {
            if (this.buffer == null) {
                return "PipedOutputStream{, startIdx=" + this.startIdx + ", endIdx=" + this.endIdx + ", readerPerceivedEndIdx=" + this.readerPerceivedEndIdx + ", closed=" + this.writerClosed + '}';
            }
            return "PipedOutputStream{bufferLength=" + this.buffer.length + ", startIdx=" + this.startIdx + ", endIdx=" + this.endIdx + ", readerPerceivedEndIdx=" + this.readerPerceivedEndIdx + (this.writerClosed ? ", closed=" + this.writerClosed : ", unread=" + BaseEncoding.base64().encode(this.getUnreadBytesFromBuffer())) + '}';
        }
    }

    static /* synthetic */ byte[] access$302(PipedOutputStream x0, byte[] x1) {
        x0.buffer = x1;
        return x1;
    }
}

