/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Pair;
import org.spf4j.io.ObjectAppender;
import org.spf4j.io.ObjectAppenderSupplier;

@ParametersAreNonnullByDefault
@Beta
public final class ConfigurableAppenderSupplier
implements ObjectAppenderSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableAppenderSupplier.class);
    private final ConcurrentMap<Class<?>, ObjectAppender<?>> lookup = new ConcurrentHashMap();
    private final LinkedList<Pair<Class<?>, ObjectAppender<?>>> registry = new LinkedList();
    public static final Predicate<Class<?>> NO_FILTER = new Predicate<Class<?>>(){

        public boolean apply(Class<?> input) {
            return false;
        }
    };

    public ConfigurableAppenderSupplier() {
        this(true, NO_FILTER, new ObjectAppender[0]);
    }

    public ConfigurableAppenderSupplier(boolean registerFromServiceLoader, Predicate<Class<?>> except, ObjectAppender<?> ... appenders) {
        if (registerFromServiceLoader) {
            ServiceLoader<ObjectAppender> load = ServiceLoader.load(ObjectAppender.class);
            for (ObjectAppender appender : load) {
                Class<?> appenderType = ConfigurableAppenderSupplier.getAppenderType(appender);
                if (except.apply(appenderType) || this.register((Class<T>)appenderType, (ObjectAppender<? super T>)appender)) continue;
                LOG.warn("Attempting to register duplicate appender({}) for {} ", (Object)appender, appenderType);
            }
        }
        for (ObjectAppender<?> appender : appenders) {
            if (this.register((Class<T>)ConfigurableAppenderSupplier.getAppenderType(appender), (ObjectAppender<? super T>)appender)) continue;
            throw new IllegalArgumentException("Cannot register appender " + appender);
        }
    }

    public static Class<?> getAppenderType(ObjectAppender<?> appender) {
        Type[] genericInterfaces = appender.getClass().getGenericInterfaces();
        Class appenderType = null;
        for (Type type : genericInterfaces) {
            ParameterizedType pType;
            if (!(type instanceof ParameterizedType) || (pType = (ParameterizedType)type).getRawType() != ObjectAppender.class) continue;
            appenderType = (Class)pType.getActualTypeArguments()[0];
            break;
        }
        if (appenderType == null) {
            throw new IllegalArgumentException("Improperly declared Appender " + appender);
        }
        return appenderType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> int register(Class<T> type, ObjectAppender<? super T> ... appenders) {
        LinkedList<Pair<Class<?>, ObjectAppender<?>>> linkedList = this.registry;
        synchronized (linkedList) {
            int i = 0;
            for (ObjectAppender<? super T> appender : appenders) {
                if (!this.register(type, appender)) break;
                ++i;
            }
            this.lookup.clear();
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void replace(Class<T> type, Function<ObjectAppender<? super T>, ObjectAppender<? super T>> replace) {
        LinkedList<Pair<Class<?>, ObjectAppender<?>>> linkedList = this.registry;
        synchronized (linkedList) {
            ListIterator<Pair<Class<T>, Object>> listIterator = this.registry.listIterator();
            while (listIterator.hasNext()) {
                Pair next = (Pair)listIterator.next();
                Class nType = (Class)next.getFirst();
                if (nType != type) continue;
                listIterator.set(Pair.of(type, replace.apply((Object)((ObjectAppender)next.getSecond()))));
                this.lookup.clear();
                return;
            }
            this.registry.add(Pair.of(type, replace.apply(ObjectAppender.TOSTRING_APPENDER)));
            this.lookup.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    private <T> boolean register(Class<T> type, ObjectAppender<? super T> appender) {
        LinkedList<Pair<Class<?>, ObjectAppender<?>>> linkedList = this.registry;
        synchronized (linkedList) {
            ListIterator<Pair<Class<T>, ObjectAppender<? super T>>> listIterator = this.registry.listIterator();
            while (listIterator.hasNext()) {
                Pair next = (Pair)listIterator.next();
                Class nType = (Class)next.getFirst();
                if (!nType.isAssignableFrom(type)) continue;
                if (nType == type) {
                    return false;
                }
                listIterator.previous();
                listIterator.add(Pair.of(type, appender));
                return true;
            }
            listIterator.add(Pair.of(type, appender));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(Class<?> type) {
        LinkedList<Pair<Class<?>, ObjectAppender<?>>> linkedList = this.registry;
        synchronized (linkedList) {
            ListIterator listIterator = this.registry.listIterator();
            while (listIterator.hasNext()) {
                Pair item = (Pair)listIterator.next();
                if (item.getFirst() != type) continue;
                listIterator.remove();
                this.lookup.clear();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ObjectAppender<? super T> get(Class<T> type) {
        ObjectAppender appender = (ObjectAppender)this.lookup.get(type);
        if (appender != null) {
            return appender;
        }
        LinkedList<Pair<Class<?>, ObjectAppender<?>>> linkedList = this.registry;
        synchronized (linkedList) {
            for (Map.Entry entry : this.registry) {
                Class clasz = (Class)entry.getKey();
                if (!clasz.isAssignableFrom(type)) continue;
                ObjectAppender value = (ObjectAppender)entry.getValue();
                this.lookup.put(type, value);
                return value;
            }
        }
        this.lookup.put(type, ObjectAppender.TOSTRING_APPENDER);
        return ObjectAppender.TOSTRING_APPENDER;
    }

    public String toString() {
        return "ConfigurableAppenderSupplier{lookup=" + this.lookup + ", registry=" + this.registry + '}';
    }
}

