/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spf4j.base.Pair;
import org.spf4j.ds.Graph;
import org.spf4j.ds.VertexEdges;

public final class HashMapGraph<V, E>
implements Graph<V, E> {
    private Map<E, Pair<V, V>> edgeNodes;
    private Map<V, VertexEdges> vertices;

    public HashMapGraph() {
        this.edgeNodes = new HashMap<E, Pair<V, V>>();
        this.vertices = new HashMap<V, VertexEdges>();
    }

    private HashMapGraph(Map<E, Pair<V, V>> edgeNodes, Map<V, VertexEdges> vertices) {
        this.edgeNodes = edgeNodes;
        this.vertices = vertices;
    }

    public void add(V vertex) {
        if (!this.vertices.containsKey(vertex)) {
            this.vertices.put(vertex, null);
        }
    }

    public void add(E edge, V fromVertex, V toVertex) {
        this.edgeNodes.put(edge, new Pair<V, V>(fromVertex, toVertex));
        VertexEdges fromV = this.vertices.get(fromVertex);
        if (fromV == null) {
            fromV = new VertexEdges();
            this.vertices.put(fromVertex, fromV);
        }
        fromV.getOutgoing().put(edge, toVertex);
        VertexEdges toV = this.vertices.get(toVertex);
        if (toV == null) {
            toV = new VertexEdges();
            this.vertices.put(toVertex, toV);
        }
        toV.getIncomming().put(edge, fromVertex);
    }

    @Override
    public Pair<V, V> getVertices(E edge) {
        return this.edgeNodes.get(edge);
    }

    @Override
    public VertexEdges<V, E> getEdges(V vertice) {
        return this.vertices.get(vertice);
    }

    @Override
    public Set<V> getVertices() {
        return this.vertices.keySet();
    }

    @Override
    public void remove(V vertice) {
        VertexEdges remove = this.vertices.remove(vertice);
        if (remove == null) {
            return;
        }
        for (Object edge : remove.getIncomming().keySet()) {
            V fromVertex = this.edgeNodes.remove(edge).getFirst();
            this.vertices.get(fromVertex).getOutgoing().remove(edge);
        }
        for (Object edge : remove.getOutgoing().keySet()) {
            V toVertex = this.edgeNodes.remove(edge).getSecond();
            this.vertices.get(toVertex).getIncomming().remove(edge);
        }
    }

    public String toString() {
        return "HashMapGraph{edgeNodes=" + this.edgeNodes + ", vertices=" + this.vertices + '}';
    }

    @Override
    public Graph<V, E> copy() {
        HashMap<VertexEdges, VertexEdges> hashMap = new HashMap<VertexEdges, VertexEdges>(this.vertices);
        for (Map.Entry<V, VertexEdges> entry : hashMap.entrySet()) {
            V v = entry.getKey();
            VertexEdges vertexEdges = entry.getValue();
            hashMap.put((VertexEdges)v, vertexEdges.copy());
        }
        return new HashMapGraph<V, E>(new HashMap<E, Pair<V, V>>(this.edgeNodes), hashMap);
    }

    @Override
    public boolean contains(V vertice) {
        return this.vertices.containsKey(vertice);
    }

    @Override
    public E getEdge(V from, V to) {
        VertexEdges edges = this.vertices.get(from);
        if (edges != null) {
            Map outgoing = edges.getOutgoing();
            for (Map.Entry entry : outgoing.entrySet()) {
                if (!entry.getValue().equals(to)) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

