/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.HandlerNano;
import org.spf4j.base.IntMath;
import org.spf4j.base.MutableHolder;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.jdbc.HeartBeatTableDesc;
import org.spf4j.concurrent.jdbc.JdbcHeartBeat;
import org.spf4j.concurrent.jdbc.OwnerPermits;
import org.spf4j.concurrent.jdbc.Semaphore;
import org.spf4j.concurrent.jdbc.SemaphoreTablesDesc;
import org.spf4j.jdbc.JdbcTemplate;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;

@SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING", "NP_LOAD_OF_KNOWN_NULL_VALUE"})
@Beta
public final class JdbcSemaphore
implements AutoCloseable,
Semaphore {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSemaphore.class);
    private final JdbcTemplate jdbc;
    private final String availablePermitsSql;
    private final String ownedPermitsSql;
    private final String totalPermitsSql;
    private final String reducePermitsSql;
    private final String increasePermitsSql;
    private final String updatePermitsSql;
    private final String acquireSql;
    private final String acquireByOwnerSql;
    private final String releaseSql;
    private final String releaseByOwnerSql;
    private final String deleteDeadOwnerRecordsSql;
    private final String getDeadOwnerPermitsSql;
    private final String deleteDeadOwerRecordSql;
    private final int jdbcTimeoutSeconds;
    private final IntMath.XorShift32 rnd;
    private final String semName;
    private final SemaphoreTablesDesc semTableDesc;
    private final JdbcHeartBeat heartBeat;
    private volatile boolean isHealthy;
    private Error heartBeatFailure;
    private static final Interner<String> INTERNER = Interners.newStrongInterner();
    private final int acquirePollMillis;
    private final JdbcHeartBeat.LifecycleHook failureHook;
    private int ownedReservations;

    public JdbcSemaphore(DataSource dataSource, String semaphoreName, int nrPermits) throws InterruptedException {
        this(dataSource, semaphoreName, nrPermits, false);
    }

    public JdbcSemaphore(DataSource dataSource, String semaphoreName, int nrPermits, boolean strict) throws InterruptedException {
        this(dataSource, SemaphoreTablesDesc.DEFAULT, semaphoreName, nrPermits, 10, strict);
    }

    public JdbcSemaphore(DataSource dataSource, SemaphoreTablesDesc semTableDesc, String semaphoreName, int nrPermits, int jdbcTimeoutSeconds, boolean strictReservations) throws InterruptedException {
        this(dataSource, semTableDesc, semaphoreName, nrPermits, jdbcTimeoutSeconds, strictReservations, Integer.getInteger("spf4j.jdbc.semaphore.defaultMaxPollIntervalMillis", 1000));
    }

    @SuppressFBWarnings(value={"CBX_CUSTOM_BUILT_XML", "STT_TOSTRING_STORED_IN_FIELD"})
    public JdbcSemaphore(DataSource dataSource, SemaphoreTablesDesc semTableDesc, String semaphoreName, int nrPermits, int jdbcTimeoutSeconds, boolean strictReservations, int acquirePollMillis) throws InterruptedException {
        if (nrPermits < 0) {
            throw new IllegalArgumentException("Permits must be positive and not " + nrPermits);
        }
        this.acquirePollMillis = acquirePollMillis;
        this.semName = (String)INTERNER.intern((Object)semaphoreName);
        this.jdbcTimeoutSeconds = jdbcTimeoutSeconds;
        this.jdbc = new JdbcTemplate(dataSource);
        this.semTableDesc = semTableDesc;
        this.rnd = new IntMath.XorShift32();
        this.isHealthy = true;
        this.ownedReservations = 0;
        this.failureHook = new JdbcHeartBeat.LifecycleHook(){

            @Override
            public void onError(Error error) {
                JdbcSemaphore.this.heartBeatFailure = error;
                JdbcSemaphore.this.isHealthy = false;
            }

            @Override
            public void onClose() {
                JdbcSemaphore.this.close();
            }
        };
        this.heartBeat = JdbcHeartBeat.getHeartBeatAndSubscribe(dataSource, semTableDesc.getHeartBeatTableDesc(), this.failureHook);
        String semaphoreTableName = semTableDesc.getSemaphoreTableName();
        String availablePermitsColumn = semTableDesc.getAvailablePermitsColumn();
        String lastModifiedByColumn = semTableDesc.getLastModifiedByColumn();
        String lastModifiedAtColumn = semTableDesc.getLastModifiedAtColumn();
        String ownerColumn = semTableDesc.getOwnerColumn();
        String semaphoreNameColumn = semTableDesc.getSemNameColumn();
        String totalPermitsColumn = semTableDesc.getTotalPermitsColumn();
        String ownerPermitsColumn = semTableDesc.getOwnerReservationsColumn();
        String permitsByOwnerTableName = semTableDesc.getPermitsByOwnerTableName();
        HeartBeatTableDesc hbTableDesc = this.heartBeat.getHbTableDesc();
        String heartBeatTableName = hbTableDesc.getTableName();
        String heartBeatOwnerColumn = hbTableDesc.getOwnerColumn();
        String currentTimeMillisFunc = hbTableDesc.getCurrentTimeMillisFunc();
        this.reducePermitsSql = "UPDATE " + semaphoreTableName + " SET " + totalPermitsColumn + " = " + totalPermitsColumn + " - ?, " + availablePermitsColumn + " = " + availablePermitsColumn + " - ? , " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ? AND " + totalPermitsColumn + " >= ?";
        this.increasePermitsSql = "UPDATE " + semaphoreTableName + " SET " + totalPermitsColumn + " = " + totalPermitsColumn + " + ?, " + availablePermitsColumn + " = " + availablePermitsColumn + " + ?, " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ? ";
        this.updatePermitsSql = "UPDATE " + semaphoreTableName + " SET " + totalPermitsColumn + " =  ?, " + availablePermitsColumn + " =  " + availablePermitsColumn + " + ? - " + totalPermitsColumn + ',' + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ?";
        this.acquireSql = "UPDATE " + semaphoreTableName + " SET " + availablePermitsColumn + " = " + availablePermitsColumn + " - ?, " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ? AND " + availablePermitsColumn + " >= ?";
        this.acquireByOwnerSql = "UPDATE " + permitsByOwnerTableName + " SET " + ownerPermitsColumn + " = " + ownerPermitsColumn + " + ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ?";
        this.releaseSql = "UPDATE " + semaphoreTableName + " SET " + availablePermitsColumn + " = CASE WHEN " + availablePermitsColumn + " + ? > " + totalPermitsColumn + " THEN " + totalPermitsColumn + " ELSE " + availablePermitsColumn + " + ? END, " + lastModifiedByColumn + " = ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + semaphoreNameColumn + " = ?";
        this.releaseByOwnerSql = "UPDATE " + permitsByOwnerTableName + " SET " + ownerPermitsColumn + " = " + ownerPermitsColumn + " - ?, " + lastModifiedAtColumn + " = " + currentTimeMillisFunc + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ? and " + ownerPermitsColumn + " >= ?";
        this.availablePermitsSql = "SELECT " + semTableDesc.getAvailablePermitsColumn() + ',' + totalPermitsColumn + " FROM " + semTableDesc.getSemaphoreTableName() + " WHERE " + semTableDesc.getSemNameColumn() + " = ?";
        this.totalPermitsSql = "SELECT " + totalPermitsColumn + ',' + totalPermitsColumn + " FROM " + semTableDesc.getSemaphoreTableName() + " WHERE " + semTableDesc.getSemNameColumn() + " = ?";
        this.ownedPermitsSql = "SELECT " + ownerPermitsColumn + " FROM " + permitsByOwnerTableName + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ?";
        this.deleteDeadOwnerRecordsSql = "DELETE FROM " + permitsByOwnerTableName + " RO WHERE RO." + semaphoreNameColumn + " = ? AND " + ownerPermitsColumn + " = 0 AND NOT EXISTS (select H." + heartBeatOwnerColumn + " from " + heartBeatTableName + " H where H." + heartBeatOwnerColumn + " = RO." + ownerColumn + ')';
        this.getDeadOwnerPermitsSql = "SELECT " + ownerColumn + ", " + ownerPermitsColumn + " FROM " + permitsByOwnerTableName + " RO WHERE RO." + semaphoreNameColumn + " = ? AND  " + ownerPermitsColumn + " > 0 AND NOT EXISTS (select H." + heartBeatOwnerColumn + " from " + heartBeatTableName + " H where H." + heartBeatOwnerColumn + " = RO." + ownerColumn + ") ORDER BY " + ownerColumn + ',' + ownerPermitsColumn;
        this.deleteDeadOwerRecordSql = "DELETE FROM " + permitsByOwnerTableName + " WHERE " + ownerColumn + " = ? AND " + semaphoreNameColumn + " = ? AND " + ownerPermitsColumn + " = ?";
        try {
            this.createLockRowIfNotPresent(strictReservations, nrPermits);
        }
        catch (SQLIntegrityConstraintViolationException ex) {
            try {
                this.createLockRowIfNotPresent(strictReservations, nrPermits);
            }
            catch (SQLException ex1) {
                RuntimeException rx = new RuntimeException(ex1);
                rx.addSuppressed(ex);
                throw rx;
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.createOwnerRow();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void registerJmx() {
        Registry.export(JdbcSemaphore.class.getName(), this.semName, this);
    }

    public void unregisterJmx() {
        Registry.unregister(JdbcSemaphore.class.getName(), this.semName);
    }

    private void validate() {
        if (!this.isHealthy) {
            throw new IllegalStateException("Heartbeats failed! semaphore broken " + this, this.heartBeatFailure);
        }
    }

    void createLockRowIfNotPresent(boolean strictReservations, int nrPermits) throws SQLException, InterruptedException {
        String lastModifiedByColumn = this.semTableDesc.getLastModifiedByColumn();
        String lastModifiedAtColumn = this.semTableDesc.getLastModifiedAtColumn();
        String tableName = this.semTableDesc.getSemaphoreTableName();
        String semNameColumn = this.semTableDesc.getSemNameColumn();
        String availableReservationsColumn = this.semTableDesc.getAvailablePermitsColumn();
        String maxReservationsColumn = this.semTableDesc.getTotalPermitsColumn();
        this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            block42: {
                try (PreparedStatement stmt = conn.prepareStatement("SELECT " + availableReservationsColumn + ',' + maxReservationsColumn + " FROM " + tableName + " WHERE " + semNameColumn + " = ?");){
                    stmt.setNString(1, this.semName);
                    stmt.setQueryTimeout((int)TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime()));
                    try (ResultSet rs = stmt.executeQuery();){
                        if (!rs.next()) {
                            try (PreparedStatement insert = conn.prepareStatement("insert into " + tableName + " (" + semNameColumn + ',' + availableReservationsColumn + ',' + maxReservationsColumn + ',' + lastModifiedByColumn + ',' + lastModifiedAtColumn + ") VALUES (?, ?, ?, ?, " + this.heartBeat.getHbTableDesc().getCurrentTimeMillisFunc() + ')');){
                                insert.setNString(1, this.semName);
                                insert.setInt(2, nrPermits);
                                insert.setInt(3, nrPermits);
                                insert.setNString(4, Runtime.PROCESS_ID);
                                insert.setQueryTimeout((int)TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime()));
                                insert.executeUpdate();
                                break block42;
                            }
                        }
                        if (strictReservations) {
                            int existingMaxReservations = rs.getInt(2);
                            if (existingMaxReservations != nrPermits) {
                                throw new IllegalArgumentException("Semaphore " + this.semName + " max reservations count different " + existingMaxReservations + " != " + nrPermits + " use different semaphore");
                            }
                            if (rs.next()) {
                                throw new IllegalStateException("Cannot have mutiple semaphores with the same name " + this.semName);
                            }
                        } else if (rs.next()) {
                            throw new IllegalStateException("Cannot have mutiple semaphores with the same name " + this.semName);
                        }
                    }
                }
            }
            return null;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    void createOwnerRow() throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            try (PreparedStatement insert = conn.prepareStatement("insert into " + this.semTableDesc.getPermitsByOwnerTableName() + " (" + this.semTableDesc.getSemNameColumn() + ',' + this.semTableDesc.getOwnerColumn() + ',' + this.semTableDesc.getOwnerReservationsColumn() + ',' + this.semTableDesc.getLastModifiedAtColumn() + ") VALUES (?, ?, ?, " + this.heartBeat.getHbTableDesc().getCurrentTimeMillisFunc() + ")");){
                insert.setNString(1, this.semName);
                insert.setNString(2, Runtime.PROCESS_ID);
                insert.setInt(3, 0);
                insert.setQueryTimeout((int)TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime()));
                insert.executeUpdate();
            }
            return null;
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    public static int nanosToSeconds(long nanos) {
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos);
        if (seconds > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)seconds;
    }

    @Override
    public void acquire(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.acquire(1, timeout, unit);
    }

    @Override
    public void acquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.tryAcquire(nrPermits, timeout, unit)) {
            throw new TimeoutException("Cannot acquire timeout after " + timeout + " " + (Object)((Object)unit));
        }
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckReturnValue
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"})
    public boolean tryAcquire(final int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
        if (nrPermits < 1) {
            throw new IllegalArgumentException("You should try to acquire something! not " + nrPermits);
        }
        String string = this.semName;
        synchronized (string) {
            long deadlineNanos = System.nanoTime() + unit.toNanos(timeout);
            boolean acquired = false;
            final MutableHolder<Boolean> beat = MutableHolder.of(Boolean.FALSE);
            do {
                this.validate();
                try {
                    acquired = this.jdbc.transactOnConnection(new HandlerNano<Connection, Boolean, SQLException>(){

                        @Override
                        public Boolean handle(Connection conn, long deadlineNanos) throws SQLException {
                            try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.acquireSql);){
                                Boolean acquired;
                                stmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
                                stmt.setInt(1, nrPermits);
                                stmt.setNString(2, Runtime.PROCESS_ID);
                                stmt.setNString(3, JdbcSemaphore.this.semName);
                                stmt.setInt(4, nrPermits);
                                int rowsUpdated = stmt.executeUpdate();
                                if (rowsUpdated == 1) {
                                    try (PreparedStatement ostmt = conn.prepareStatement(JdbcSemaphore.this.acquireByOwnerSql);){
                                        ostmt.setInt(1, nrPermits);
                                        ostmt.setNString(2, Runtime.PROCESS_ID);
                                        ostmt.setNString(3, JdbcSemaphore.this.semName);
                                        ostmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
                                        int nrUpdated = ostmt.executeUpdate();
                                        if (nrUpdated != 1) {
                                            throw new IllegalStateException("Updated " + nrUpdated + " is incorrect for " + ostmt);
                                        }
                                    }
                                    acquired = Boolean.TRUE;
                                } else {
                                    if (rowsUpdated > 1) {
                                        throw new IllegalStateException("Too many rows updated! when trying to acquire " + nrPermits);
                                    }
                                    acquired = Boolean.FALSE;
                                }
                                if (deadlineNanos - System.nanoTime() > JdbcSemaphore.this.heartBeat.getBeatDurationNanos()) {
                                    beat.setValue(JdbcSemaphore.this.heartBeat.tryBeat(conn, deadlineNanos));
                                }
                                Boolean bl = acquired;
                                return bl;
                            }
                        }
                    }, timeout, unit);
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
                if (beat.getValue().booleanValue()) {
                    this.heartBeat.updateLastRun(System.currentTimeMillis());
                }
                if (acquired) continue;
                Future<Integer> fut = DefaultExecutor.INSTANCE.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return JdbcSemaphore.this.removeDeadHeartBeatAndNotOwnerRows(60);
                    }
                });
                try {
                    fut.get(deadlineNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
                }
                catch (TimeoutException ex) {
                    break;
                }
                catch (ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
                if (this.releaseDeadOwnerPermits(nrPermits) > 0) continue;
                long wtimeMilis = Math.min(TimeUnit.NANOSECONDS.toMillis(deadlineNanos - System.nanoTime()), (long)(Math.abs(this.rnd.nextInt()) % this.acquirePollMillis));
                if (wtimeMilis <= 0L) break;
                this.semName.wait(wtimeMilis);
            } while (!acquired && deadlineNanos > System.nanoTime());
            if (acquired) {
                this.ownedReservations += nrPermits;
            }
            return acquired;
        }
    }

    @Override
    public void release() {
        this.release(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void release(final int nrReservations) {
        String string = this.semName;
        synchronized (string) {
            try {
                this.jdbc.transactOnConnectionNonInterrupt(new HandlerNano<Connection, Void, SQLException>(){

                    @Override
                    public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                        JdbcSemaphore.this.releaseReservations(conn, deadlineNanos, nrReservations);
                        try (PreparedStatement ostmt = conn.prepareStatement(JdbcSemaphore.this.releaseByOwnerSql);){
                            ostmt.setInt(1, nrReservations);
                            ostmt.setNString(2, Runtime.PROCESS_ID);
                            ostmt.setNString(3, JdbcSemaphore.this.semName);
                            ostmt.setInt(4, nrReservations);
                            ostmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
                            int nrUpdated = ostmt.executeUpdate();
                            if (nrUpdated != 1) {
                                throw new IllegalStateException("Trying to release more than you own! " + ostmt);
                            }
                        }
                        return null;
                    }
                }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            this.ownedReservations -= nrReservations;
            if (this.ownedReservations < 0) {
                throw new IllegalStateException("Should not be trying to release more than you acquired!" + nrReservations);
            }
            this.semName.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        String string = this.semName;
        synchronized (string) {
            this.release(this.ownedReservations);
        }
    }

    private void releaseReservations(Connection conn, long deadlineNanos, int nrReservations) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(this.releaseSql);){
            stmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
            stmt.setInt(1, nrReservations);
            stmt.setInt(2, nrReservations);
            stmt.setNString(3, Runtime.PROCESS_ID);
            stmt.setNString(4, this.semName);
            stmt.executeUpdate();
        }
    }

    @JmxExport(description="Get the available semaphore permits")
    public int availablePermits() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="get the number of permits owned by this process")
    public int permitsOwned() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Get the total permits this semaphore can hand out")
    public int totalPermits() throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="get a list of all dead owners which hold permits")
    public List<OwnerPermits> getDeadOwnerPermits(int wishPermits) throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection((conn, deadlineNanos) -> this.getDeadOwnerPermits((Connection)conn, deadlineNanos, wishPermits), this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    List<OwnerPermits> getDeadOwnerPermits(Connection conn, long deadlineNanos, int wishPermits) throws SQLException {
        ArrayList<OwnerPermits> result = new ArrayList<OwnerPermits>();
        try (PreparedStatement stmt = conn.prepareStatement(this.getDeadOwnerPermitsSql);){
            stmt.setNString(1, this.semName);
            stmt.setQueryTimeout((int)TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime()));
            try (ResultSet rs = stmt.executeQuery();){
                int nrPermits = 0;
                while (rs.next()) {
                    OwnerPermits ownerPermit = new OwnerPermits(rs.getNString(1), rs.getInt(2));
                    result.add(ownerPermit);
                    if ((nrPermits += ownerPermit.getNrPermits()) < wishPermits) continue;
                    break;
                }
            }
        }
        return result;
    }

    @JmxExport(description="release dead owner permits")
    @CheckReturnValue
    public int releaseDeadOwnerPermits(@JmxExport(value="wishPermits", description="how many we whish to release") int wishPermits) throws InterruptedException {
        try {
            return this.jdbc.transactOnConnection((conn, deadlineNanos) -> {
                List<OwnerPermits> deadOwnerPermits = this.getDeadOwnerPermits((Connection)conn, deadlineNanos, wishPermits);
                int released = 0;
                for (OwnerPermits permit : deadOwnerPermits) {
                    PreparedStatement stmt = conn.prepareStatement(this.deleteDeadOwerRecordSql);
                    Throwable throwable = null;
                    try {
                        String owner = permit.getOwner();
                        stmt.setNString(1, owner);
                        stmt.setNString(2, this.semName);
                        int nrPermits = permit.getNrPermits();
                        stmt.setInt(3, nrPermits);
                        stmt.setQueryTimeout((int)TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime()));
                        if (stmt.executeUpdate() != 1) continue;
                        released += nrPermits;
                        this.releaseReservations((Connection)conn, deadlineNanos, nrPermits);
                        LOG.warn("Released {} reservations from dead owner {}", (Object)nrPermits, (Object)owner);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stmt == null) continue;
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stmt.close();
                    }
                }
                return released;
            }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @JmxExport(description="Change the total available permits to the provided number")
    public void updatePermits(final int nrPermits) throws SQLException, InterruptedException {
        if (nrPermits < 0) {
            throw new IllegalArgumentException("Permits must be positive and not " + nrPermits);
        }
        this.jdbc.transactOnConnection(new HandlerNano<Connection, Void, SQLException>(){

            @Override
            public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.updatePermitsSql);){
                    stmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
                    stmt.setInt(1, nrPermits);
                    stmt.setInt(2, nrPermits);
                    stmt.setNString(3, Runtime.PROCESS_ID);
                    stmt.setNString(4, JdbcSemaphore.this.semName);
                    int rowsUpdated = stmt.executeUpdate();
                    if (rowsUpdated != 1) {
                        throw new IllegalArgumentException("Cannot reduce nr total permits by " + nrPermits);
                    }
                }
                return null;
            }
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Reduce the total available permits by the provided number")
    public void reducePermits(final int nrPermits) throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection(new HandlerNano<Connection, Void, SQLException>(){

            @Override
            public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.reducePermitsSql);){
                    stmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
                    stmt.setInt(1, nrPermits);
                    stmt.setInt(2, nrPermits);
                    stmt.setNString(3, Runtime.PROCESS_ID);
                    stmt.setNString(4, JdbcSemaphore.this.semName);
                    stmt.setInt(5, nrPermits);
                    int rowsUpdated = stmt.executeUpdate();
                    if (rowsUpdated != 1) {
                        throw new IllegalArgumentException("Cannot reduce nr total permits by " + nrPermits);
                    }
                }
                return null;
            }
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    @JmxExport(description="Increase the total available permits by the provided number")
    public void increasePermits(final int nrPermits) throws SQLException, InterruptedException {
        this.jdbc.transactOnConnection(new HandlerNano<Connection, Void, SQLException>(){

            @Override
            public Void handle(Connection conn, long deadlineNanos) throws SQLException {
                try (PreparedStatement stmt = conn.prepareStatement(JdbcSemaphore.this.increasePermitsSql);){
                    stmt.setQueryTimeout(JdbcSemaphore.nanosToSeconds(deadlineNanos - System.nanoTime()));
                    stmt.setInt(1, nrPermits);
                    stmt.setInt(2, nrPermits);
                    stmt.setNString(3, Runtime.PROCESS_ID);
                    stmt.setNString(4, JdbcSemaphore.this.semName);
                    int rowsUpdated = stmt.executeUpdate();
                    if (rowsUpdated != 1) {
                        throw new IllegalArgumentException("Cannot reduce nr total permits by " + nrPermits);
                    }
                }
                return null;
            }
        }, this.jdbcTimeoutSeconds, TimeUnit.SECONDS);
    }

    public int removeDeadHeartBeatAndNotOwnerRows(int timeoutSeconds) throws SQLException, InterruptedException {
        return this.jdbc.transactOnConnection(new HandlerNano<Connection, Integer, SQLException>(){

            @Override
            public Integer handle(Connection conn, long deadlineNanos) throws SQLException {
                return JdbcSemaphore.this.removeDeadHeartBeatAndNotOwnerRows(conn, deadlineNanos);
            }
        }, timeoutSeconds, TimeUnit.SECONDS);
    }

    int removeDeadHeartBeatAndNotOwnerRows(Connection conn, long deadlineNanos) throws SQLException {
        int removedDeadHeartBeatRows = this.heartBeat.removeDeadHeartBeatRows(conn, deadlineNanos);
        if (removedDeadHeartBeatRows > 0) {
            return this.removeDeadNotOwnedRowsOnly(conn, deadlineNanos);
        }
        return 0;
    }

    int removeDeadNotOwnedRowsOnly(Connection conn, long deadlineNanos) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(this.deleteDeadOwnerRecordsSql);){
            stmt.setNString(1, this.semName);
            stmt.setQueryTimeout((int)TimeUnit.NANOSECONDS.toSeconds(deadlineNanos - System.nanoTime()));
            int n = stmt.executeUpdate();
            return n;
        }
    }

    public String toString() {
        return "JdbcSemaphore{jdbc=" + this.jdbc + ", jdbcTimeoutSeconds=" + this.jdbcTimeoutSeconds + ", semName=" + this.semName + '}';
    }

    @Override
    public void close() {
        this.releaseAll();
        this.unregisterJmx();
        this.heartBeat.removeLifecycleHook(this.failureHook);
        this.isHealthy = false;
    }

    @JmxExport
    public int getJdbcTimeoutSeconds() {
        return this.jdbcTimeoutSeconds;
    }

    @JmxExport
    public boolean isIsHealthy() {
        return this.isHealthy;
    }
}

