/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class UnboundedLoadingCache2<K, V>
implements LoadingCache<K, V> {
    private final ConcurrentMap<K, V> map;
    private final CacheLoader<K, V> loader;
    private final Function<K, V> computer;

    public UnboundedLoadingCache2(int initialSize, CacheLoader<K, V> loader) {
        this(initialSize, 8, loader);
    }

    public UnboundedLoadingCache2(int initialSize, int concurrency, final CacheLoader<K, V> loader) {
        this.map = new ConcurrentHashMap(initialSize, 0.75f, concurrency);
        this.loader = loader;
        this.computer = new Function<K, V>(){

            @Override
            public V apply(K t) {
                try {
                    return loader.load(t);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public V get(K key) {
        return this.map.computeIfAbsent(key, this.computer);
    }

    public V getUnchecked(K key) {
        return this.get(key);
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (K key : keys) {
            builder.put(key, this.get(key));
        }
        return builder.build();
    }

    public V apply(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null for " + this);
        }
        return this.getUnchecked(key);
    }

    public void refresh(K key) {
        this.getUnchecked(key);
    }

    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public V getIfPresent(Object key) {
        return this.map.get(key);
    }

    public V get(K key, final Callable<? extends V> valueLoader) {
        return this.map.computeIfAbsent(key, new Function<K, V>(){

            @Override
            public V apply(K t) {
                try {
                    return valueLoader.call();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : keys) {
            V val = this.getIfPresent(key);
            if (val == null) continue;
            builder.put(key, val);
        }
        return builder.build();
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void invalidate(Object key) {
        this.map.remove(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.invalidate(key);
        }
    }

    public void invalidateAll() {
        this.map.clear();
    }

    public long size() {
        return this.map.size();
    }

    public CacheStats stats() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void cleanUp() {
        this.map.clear();
    }

    public String toString() {
        return "UnboundedLoadingCache{map=" + this.map + ", loader=" + this.loader + '}';
    }
}

