/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.io.IOException;
import java.io.Writer;
import org.spf4j.base.CharSequenceTranslator;

public final class UnicodeUnescaper
extends CharSequenceTranslator {
    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        int length = input.length();
        if (index + 1 < length && input.charAt(index) == '\\' && input.charAt(index + 1) == 'u') {
            int i = 2;
            while (index + i < length && input.charAt(index + i) == 'u') {
                ++i;
            }
            if (index + i < length && input.charAt(index + i) == '+') {
                ++i;
            }
            if (index + i + 4 <= length) {
                CharSequence unicode = input.subSequence(index + i, index + i + 4);
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.write((char)value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                }
                return i + 4;
            }
            throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index, length) + "' due to end of CharSequence");
        }
        return 0;
    }
}

