/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Callables;
import org.spf4j.base.CallablesNano;
import org.spf4j.base.IntMath;
import org.spf4j.base.Throwables;

@ParametersAreNonnullByDefault
@Beta
public final class CallablesNanoNonInterrupt {
    private static final Logger LOG = LoggerFactory.getLogger(CallablesNanoNonInterrupt.class);
    public static final RetryPredicate<?, RuntimeException> RETRY_FOR_NULL_RESULT = new RetryPredicate<Object, RuntimeException>(){

        @Override
        public Callables.Action apply(Object input) {
            return input != null ? Callables.Action.ABORT : Callables.Action.RETRY;
        }
    };
    public static final Predicate<Exception> DEFAULT_EXCEPTION_RETRY_PREDICATE = new Predicate<Exception>(){

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public boolean apply(Exception t) {
            return Callables.DEFAULT_EXCEPTION_RETRY.apply(t) != Callables.AdvancedAction.ABORT;
        }
    };
    private static final Function<Exception, Object> EX_TYPE_CLASS_MAPPER = new Function<Exception, Object>(){

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public Object apply(Exception f) {
            return com.google.common.base.Throwables.getStackTraceAsString((Throwable)f).getClass();
        }
    };

    private CallablesNanoNonInterrupt() {
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, long maxRetryWaitNanos) throws EX, TimeoutException {
        return (T)CallablesNanoNonInterrupt.executeWithRetry(what, nrImmediateRetries, maxRetryWaitNanos, TimeoutRetryPredicate.NORETRY_FOR_RESULT, Callables.DEFAULT_EXCEPTION_RETRY);
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, long maxRetryWaitNanos, Callables.AdvancedRetryPredicate<Exception> retryOnException) throws EX, TimeoutException {
        return (T)CallablesNanoNonInterrupt.executeWithRetry(what, nrImmediateRetries, maxRetryWaitNanos, TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException);
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, long maxWaitNanos, TimeoutRetryPredicate<? super T> retryOnReturnVal, Callables.AdvancedRetryPredicate<Exception> retryOnException) throws EX, TimeoutException {
        return CallablesNanoNonInterrupt.executeWithRetry(what, retryOnReturnVal, new FibonacciBackoffRetryPredicate<Exception>(retryOnException, nrImmediateRetries, maxWaitNanos / 100L, maxWaitNanos, EX_TYPE_CLASS_MAPPER));
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutRetryPredicate<? super T> retryOnReturnVal, TimeoutRetryPredicate<Exception> retryOnException) throws EX, TimeoutException {
        long deadlineNanos = what.getDeadlineNanos();
        return CallablesNanoNonInterrupt.executeWithRetry(what, new TimeoutRetryPredicate2RetryPredicate<T>(deadlineNanos, retryOnReturnVal), new TimeoutRetryPredicate2RetryPredicate<Exception>(deadlineNanos, retryOnException));
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutDelayPredicate<T> retryOnReturnVal, TimeoutDelayPredicate<Exception> retryOnException) throws EX, TimeoutException {
        return CallablesNanoNonInterrupt.executeWithRetry(what, new SmartRetryPredicate2TimeoutRetryPredicate<T>(retryOnReturnVal), new SmartRetryPredicate2TimeoutRetryPredicate<Exception>(retryOnException));
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutDelayPredicate<Exception> retryOnException) throws EX, TimeoutException {
        return (T)CallablesNanoNonInterrupt.executeWithRetry(what, TimeoutDelayPredicate.NORETRY_FOR_RESULT, retryOnException);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    public static <T, EX extends Exception, EX2 extends Exception> T executeWithRetry(RetryCallable<T, EX> what, RetryPredicate<? super T, EX2> retryOnReturnVal, RetryPredicate<Exception, EX2> retryOnException) throws EX, EX2, TimeoutException {
        Object result = null;
        Exception lastEx = null;
        try {
            result = what.call();
        }
        catch (Exception e) {
            lastEx = e;
        }
        Exception lastExChain = lastEx;
        while (lastEx != null && retryOnException.apply(lastEx) == Callables.Action.RETRY || retryOnReturnVal.apply(result) == Callables.Action.RETRY) {
            result = null;
            lastEx = null;
            try {
                result = what.call();
            }
            catch (Exception e) {
                lastEx = e;
                if (lastExChain != null) {
                    lastExChain = Throwables.suppress(e, lastExChain);
                    continue;
                }
                lastExChain = e;
            }
        }
        if (lastEx != null) {
            if (lastExChain instanceof RuntimeException) {
                throw what.lastException((RuntimeException)lastExChain);
            }
            throw what.lastException(lastExChain);
        }
        return what.lastReturn(result);
    }

    public static interface RetryCallable<T, EX extends Exception>
    extends CallablesNano.RetryCallable<T, EX> {
        @Override
        public T call() throws EX, TimeoutException;
    }

    public static interface RetryPredicate<T, EX extends Exception> {
        public Callables.Action apply(T var1) throws EX;
    }

    public static abstract class CheckedCallable<T, EX extends Exception>
    implements RetryCallable<T, EX> {
        @Override
        public T lastReturn(T lastRet) {
            return lastRet;
        }

        @Override
        public <EXX extends Exception> EXX lastException(EXX ex) throws EXX {
            throw ex;
        }

        @Override
        public abstract T call() throws EX, TimeoutException;
    }

    public static final class TimeoutRetryPredicate2RetryPredicate<T>
    implements RetryPredicate<T, TimeoutException> {
        private final long deadlineNanos;
        private final TimeoutRetryPredicate<T> predicate;

        public TimeoutRetryPredicate2RetryPredicate(long deadlineNanos, TimeoutRetryPredicate<T> predicate) {
            this.deadlineNanos = deadlineNanos;
            this.predicate = predicate;
        }

        @Override
        @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
        public Callables.Action apply(T value) throws TimeoutException {
            return this.predicate.apply(value, this.deadlineNanos);
        }
    }

    public static interface TimeoutRetryPredicate<T> {
        public static final TimeoutRetryPredicate<Object> NORETRY_FOR_RESULT = new TimeoutRetryPredicate<Object>(){

            @Override
            public Callables.Action apply(Object value, long deadlineNanos) {
                return Callables.Action.ABORT;
            }
        };

        public Callables.Action apply(T var1, long var2) throws TimeoutException;
    }

    public static final class SmartRetryPredicate2TimeoutRetryPredicate<T>
    implements TimeoutRetryPredicate<T> {
        private final TimeoutDelayPredicate predicate;

        public SmartRetryPredicate2TimeoutRetryPredicate(TimeoutDelayPredicate<T> predicate) {
            this.predicate = predicate;
        }

        @Override
        @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
        public Callables.Action apply(T value, long deadlineNanos) {
            long apply = this.predicate.apply(value, deadlineNanos);
            if (apply < 0L) {
                return Callables.Action.ABORT;
            }
            if (apply == 0L) {
                return Callables.Action.RETRY;
            }
            try {
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(apply));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            return Callables.Action.RETRY;
        }
    }

    public static interface TimeoutDelayPredicate<T> {
        public static final TimeoutDelayPredicate<Object> NORETRY_FOR_RESULT = new TimeoutDelayPredicate<Object>(){

            @Override
            public long apply(Object value, long deadlineNanos) {
                return -1L;
            }
        };

        public long apply(T var1, long var2);
    }

    public static interface DelayPredicate<T> {
        public static final DelayPredicate<Object> NORETRY_DELAY_PREDICATE = new DelayPredicate<Object>(){

            @Override
            public int apply(Object value) {
                return -1;
            }
        };

        public int apply(T var1);
    }

    public static abstract class TimeoutCallable<T, EX extends Exception>
    extends CheckedCallable<T, EX> {
        private final long mdeadlineNanos;

        public TimeoutCallable(long timeoutNanos) {
            this.mdeadlineNanos = System.nanoTime() + timeoutNanos;
        }

        @Override
        public final T call() throws EX, TimeoutException {
            return this.call(this.mdeadlineNanos);
        }

        public abstract T call(long var1) throws EX, TimeoutException;

        public final long getDeadlineNanos() {
            return this.mdeadlineNanos;
        }
    }

    public static final class FibonacciBackoffRetryPredicate<T>
    implements TimeoutRetryPredicate<T> {
        private final IntMath.XorShift32 random;
        private final Callables.AdvancedRetryPredicate<T> arp;
        private final int nrImmediateRetries;
        private final long maxWaitNanos;
        private final long minWaitNanos;
        private Map<Object, RetryData> retryRegistry;
        private final Function<T, Object> mapper;

        public FibonacciBackoffRetryPredicate(Callables.AdvancedRetryPredicate<T> arp, int nrImmediateRetries, long minWaitNanos, long maxWaitNanos, Function<T, Object> mapper) {
            this.arp = arp;
            this.nrImmediateRetries = nrImmediateRetries;
            this.maxWaitNanos = maxWaitNanos;
            this.minWaitNanos = minWaitNanos;
            this.retryRegistry = null;
            this.mapper = mapper;
            this.random = new IntMath.XorShift32();
        }

        @Override
        @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
        public Callables.Action apply(T value, long deadlineNanos) throws TimeoutException {
            long currentTimeNanos = System.nanoTime();
            if (currentTimeNanos > deadlineNanos) {
                return Callables.Action.ABORT;
            }
            if (this.retryRegistry == null) {
                this.retryRegistry = new HashMap<Object, RetryData>();
            }
            Callables.AdvancedAction action = this.arp.apply(value, deadlineNanos);
            switch (action) {
                case ABORT: {
                    return Callables.Action.ABORT;
                }
                case RETRY_IMMEDIATE: {
                    return Callables.Action.RETRY;
                }
                case RETRY_DELAYED: 
                case RETRY: {
                    RetryData retryData = this.getRetryData(value, action);
                    long nextDelay = retryData.nextDelayNanos();
                    long delayNanos = Math.min(nextDelay, deadlineNanos - currentTimeNanos);
                    if (delayNanos > 0L) {
                        delayNanos = (long)Math.abs(this.random.nextInt()) % delayNanos;
                        try {
                            Thread.sleep(TimeUnit.NANOSECONDS.toMillis(delayNanos));
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    return Callables.Action.RETRY;
                }
            }
            throw new RuntimeException("Unsupperted Retry Action " + (Object)((Object)action));
        }

        RetryData getRetryData(T value, Callables.AdvancedAction action) {
            Object rootCauseClass = this.mapper.apply(value);
            RetryData data = this.retryRegistry.get(rootCauseClass);
            if (data == null) {
                data = this.createRetryData(action);
                this.retryRegistry.put(rootCauseClass, data);
            }
            return data;
        }

        private RetryData createRetryData(Callables.AdvancedAction action) {
            if (action == Callables.AdvancedAction.RETRY_DELAYED) {
                return new RetryData(0L, this.minWaitNanos, this.maxWaitNanos);
            }
            return new RetryData(this.nrImmediateRetries, this.minWaitNanos, this.maxWaitNanos);
        }
    }

    private static final class RetryData {
        private long immediateLeft;
        private long p1;
        private long p2;
        private final long maxDelayNanos;

        RetryData(long immediateLeft, long p1, long maxDelayNanos) {
            this.immediateLeft = immediateLeft;
            if (p1 < 1L) {
                this.p1 = 0L;
                this.p2 = 1L;
            } else {
                this.p1 = p1;
                this.p2 = p1;
            }
            this.maxDelayNanos = maxDelayNanos;
        }

        long nextDelayNanos() {
            if (this.immediateLeft > 0L) {
                --this.immediateLeft;
                return 0L;
            }
            if (this.p2 > this.maxDelayNanos) {
                return this.maxDelayNanos;
            }
            long result = this.p2;
            this.p2 = this.p1 + this.p2;
            this.p1 = result;
            return result;
        }
    }
}

