/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.IntMath;
import org.spf4j.base.Throwables;

@ParametersAreNonnullByDefault
public final class Callables {
    private static final Logger LOG = LoggerFactory.getLogger(Callables.class);
    public static final RetryPredicate<?> RETRY_FOR_NULL_RESULT = new RetryPredicate<Object>(){

        @Override
        public Action apply(Object input) {
            return input != null ? Action.ABORT : Action.RETRY;
        }
    };
    public static final AdvancedRetryPredicate<Exception> DEFAULT_EXCEPTION_RETRY = new AdvancedRetryPredicate<Exception>(){

        @Override
        public AdvancedAction apply(@Nonnull Exception input) {
            Throwable rootCause = com.google.common.base.Throwables.getRootCause((Throwable)input);
            if (rootCause instanceof RuntimeException) {
                return AdvancedAction.ABORT;
            }
            if (rootCause instanceof SQLTransientException || rootCause instanceof SQLRecoverableException || rootCause instanceof IOException || rootCause instanceof TimeoutException) {
                LOG.debug("Exception encountered, retrying...", (Throwable)input);
                return AdvancedAction.RETRY;
            }
            return AdvancedAction.ABORT;
        }
    };
    public static final Predicate<Exception> DEFAULT_EXCEPTION_RETRY_PREDICATE = new Predicate<Exception>(){

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public boolean apply(Exception t) {
            return DEFAULT_EXCEPTION_RETRY.apply(t) != AdvancedAction.ABORT;
        }
    };
    private static final Function<Exception, Object> EX_TYPE_CLASS_MAPPER = new Function<Exception, Object>(){

        @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public Object apply(Exception f) {
            return com.google.common.base.Throwables.getStackTraceAsString((Throwable)f).getClass();
        }
    };

    private Callables() {
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, int maxRetryWaitMillis) throws InterruptedException, EX {
        return (T)Callables.executeWithRetry(what, nrImmediateRetries, maxRetryWaitMillis, TimeoutRetryPredicate.NORETRY_FOR_RESULT, DEFAULT_EXCEPTION_RETRY);
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, int maxRetryWaitMillis, AdvancedRetryPredicate<Exception> retryOnException) throws InterruptedException, EX {
        return (T)Callables.executeWithRetry(what, nrImmediateRetries, maxRetryWaitMillis, TimeoutRetryPredicate.NORETRY_FOR_RESULT, retryOnException);
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, int nrImmediateRetries, int maxWaitMillis, TimeoutRetryPredicate<? super T> retryOnReturnVal, AdvancedRetryPredicate<Exception> retryOnException) throws InterruptedException, EX {
        return Callables.executeWithRetry(what, retryOnReturnVal, new FibonacciBackoffRetryPredicate<Exception>(retryOnException, nrImmediateRetries, maxWaitMillis / 100, maxWaitMillis, EX_TYPE_CLASS_MAPPER));
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutRetryPredicate<? super T> retryOnReturnVal, TimeoutRetryPredicate<Exception> retryOnException) throws InterruptedException, EX {
        long deadline = what.getDeadline();
        return Callables.executeWithRetry(what, new TimeoutRetryPredicate2RetryPredicate<T>(deadline, retryOnReturnVal), new TimeoutRetryPredicate2RetryPredicate<Exception>(deadline, retryOnException));
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutDelayPredicate<T> retryOnReturnVal, TimeoutDelayPredicate<Exception> retryOnException) throws InterruptedException, EX {
        return Callables.executeWithRetry(what, new SmartRetryPredicate2TimeoutRetryPredicate<T>(retryOnReturnVal), new SmartRetryPredicate2TimeoutRetryPredicate<Exception>(retryOnException));
    }

    public static <T, EX extends Exception> T executeWithRetry(TimeoutCallable<T, EX> what, TimeoutDelayPredicate<Exception> retryOnException) throws InterruptedException, EX {
        return (T)Callables.executeWithRetry(what, TimeoutDelayPredicate.NORETRY_FOR_RESULT, retryOnException);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    public static <T, EX extends Exception> T executeWithRetry(RetryCallable<T, EX> what, RetryPredicate<? super T> retryOnReturnVal, RetryPredicate<Exception> retryOnException) throws InterruptedException, EX {
        Object result = null;
        Exception lastEx = null;
        try {
            result = what.call();
        }
        catch (InterruptedException ex1) {
            throw what.lastException(ex1);
        }
        catch (Exception e) {
            lastEx = e;
        }
        Exception lastExChain = lastEx;
        while (lastEx != null && retryOnException.apply(lastEx) == Action.RETRY || retryOnReturnVal.apply(result) == Action.RETRY) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                throw what.lastException(new InterruptedException());
            }
            result = null;
            lastEx = null;
            try {
                result = what.call();
            }
            catch (InterruptedException ex1) {
                throw what.lastException(ex1);
            }
            catch (Exception e) {
                lastEx = e;
                if (lastExChain != null) {
                    lastExChain = Throwables.suppress(e, lastExChain);
                    continue;
                }
                lastExChain = e;
            }
        }
        if (lastEx != null) {
            if (lastExChain instanceof RuntimeException) {
                throw what.lastException((RuntimeException)lastExChain);
            }
            throw what.lastException(lastExChain);
        }
        return what.lastReturn(result);
    }

    public static <T> Callable<T> synchronize(final Callable<T> callable) {
        return new Callable<T>(){

            @Override
            public synchronized T call() throws Exception {
                return callable.call();
            }
        };
    }

    public static <T> Callable<T> withName(final Callable<T> callable, final String name) {
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                String origName = currentThread.getName();
                try {
                    currentThread.setName(origName + '[' + name + ']');
                    Object v = callable.call();
                    return v;
                }
                finally {
                    currentThread.setName(origName);
                }
            }

            public String toString() {
                return name;
            }
        };
    }

    public static interface RetryPredicate<T> {
        public Action apply(T var1) throws InterruptedException;
    }

    public static enum Action {
        RETRY,
        ABORT;

    }

    public static interface RetryCallable<T, EX extends Exception>
    extends Callable<T> {
        @Override
        public T call() throws EX, InterruptedException, TimeoutException;

        public T lastReturn(T var1);

        public <EXX extends Exception> EXX lastException(EXX var1) throws EXX;
    }

    public static abstract class CheckedCallable<T, EX extends Exception>
    implements RetryCallable<T, EX> {
        @Override
        public T lastReturn(T lastRet) {
            return lastRet;
        }

        @Override
        public <EXX extends Exception> EXX lastException(EXX ex) throws EXX {
            throw ex;
        }

        @Override
        public abstract T call() throws EX, InterruptedException, TimeoutException;
    }

    public static final class TimeoutRetryPredicate2RetryPredicate<T>
    implements RetryPredicate<T> {
        private final long deadline;
        private final TimeoutRetryPredicate<T> predicate;

        public TimeoutRetryPredicate2RetryPredicate(long deadline, TimeoutRetryPredicate<T> predicate) {
            this.deadline = deadline;
            this.predicate = predicate;
        }

        @Override
        public Action apply(T value) throws InterruptedException {
            try {
                return this.predicate.apply(value, this.deadline);
            }
            catch (TimeoutException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static interface TimeoutRetryPredicate<T> {
        public static final TimeoutRetryPredicate<Object> NORETRY_FOR_RESULT = new TimeoutRetryPredicate<Object>(){

            @Override
            public Action apply(Object value, long deadline) {
                return Action.ABORT;
            }
        };

        public Action apply(T var1, long var2) throws InterruptedException, TimeoutException;
    }

    public static final class SmartRetryPredicate2TimeoutRetryPredicate<T>
    implements TimeoutRetryPredicate<T> {
        private final TimeoutDelayPredicate predicate;

        public SmartRetryPredicate2TimeoutRetryPredicate(TimeoutDelayPredicate<T> predicate) {
            this.predicate = predicate;
        }

        @Override
        @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
        public Action apply(T value, long deadline) throws InterruptedException {
            int apply = this.predicate.apply(value, deadline);
            if (apply < 0) {
                return Action.ABORT;
            }
            if (apply == 0) {
                return Action.RETRY;
            }
            Thread.sleep(apply);
            return Action.RETRY;
        }
    }

    public static interface TimeoutDelayPredicate<T> {
        public static final TimeoutDelayPredicate<Object> NORETRY_FOR_RESULT = new TimeoutDelayPredicate<Object>(){

            @Override
            public int apply(Object value, long deadline) {
                return -1;
            }
        };

        public int apply(T var1, long var2);
    }

    public static interface DelayPredicate<T> {
        public static final DelayPredicate<Object> NORETRY_DELAY_PREDICATE = new DelayPredicate<Object>(){

            @Override
            public int apply(Object value) {
                return -1;
            }
        };

        public int apply(T var1);
    }

    public static abstract class AdvancedRetryPredicate<T> {
        public static final AdvancedRetryPredicate<?> NO_RETRY = new AdvancedRetryPredicate<Object>(){

            @Override
            public AdvancedAction apply(Object value) {
                return AdvancedAction.ABORT;
            }
        };

        public AdvancedAction apply(T value, long deadline) {
            return this.apply(value);
        }

        public abstract AdvancedAction apply(T var1);
    }

    public static enum AdvancedAction {
        RETRY,
        RETRY_IMMEDIATE,
        RETRY_DELAYED,
        ABORT;

    }

    public static abstract class TimeoutCallable<T, EX extends Exception>
    extends CheckedCallable<T, EX> {
        private final long mdeadline;

        public TimeoutCallable(int timeoutMillis) {
            this.mdeadline = System.currentTimeMillis() + (long)timeoutMillis;
        }

        @Override
        public final T call() throws EX, InterruptedException, TimeoutException {
            return this.call(this.mdeadline);
        }

        public abstract T call(long var1) throws EX, InterruptedException, TimeoutException;

        public final long getDeadline() {
            return this.mdeadline;
        }
    }

    public static final class FibonacciBackoffRetryPredicate<T>
    implements TimeoutRetryPredicate<T> {
        private final IntMath.XorShift32 random;
        private final AdvancedRetryPredicate<T> arp;
        private final int nrImmediateRetries;
        private final int maxWaitMillis;
        private final int minWaitMillis;
        private Map<Object, RetryData> retryRegistry;
        private final Function<T, Object> mapper;

        public FibonacciBackoffRetryPredicate(AdvancedRetryPredicate<T> arp, int nrImmediateRetries, int minWaitMillis, int maxWaitMillis, Function<T, Object> mapper) {
            this.arp = arp;
            this.nrImmediateRetries = nrImmediateRetries;
            this.maxWaitMillis = maxWaitMillis;
            this.minWaitMillis = minWaitMillis;
            this.retryRegistry = null;
            this.mapper = mapper;
            this.random = new IntMath.XorShift32();
        }

        @Override
        @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
        public Action apply(T value, long deadline) throws InterruptedException, TimeoutException {
            long currentTime = System.currentTimeMillis();
            if (currentTime > deadline) {
                return Action.ABORT;
            }
            if (this.retryRegistry == null) {
                this.retryRegistry = new HashMap<Object, RetryData>();
            }
            AdvancedAction action = this.arp.apply(value, deadline);
            switch (action) {
                case ABORT: {
                    return Action.ABORT;
                }
                case RETRY_IMMEDIATE: {
                    return Action.RETRY;
                }
                case RETRY_DELAYED: 
                case RETRY: {
                    RetryData retryData = this.getRetryData(value, action);
                    int nextDelay = retryData.nextDelay();
                    long delay = Math.min((long)nextDelay, deadline - currentTime);
                    if (delay > 0L) {
                        delay = (long)Math.abs(this.random.nextInt()) % delay;
                        Thread.sleep(delay);
                    }
                    return Action.RETRY;
                }
            }
            throw new RuntimeException("Unsupperted Retry Action " + (Object)((Object)action));
        }

        RetryData getRetryData(T value, AdvancedAction action) {
            Object rootCauseClass = this.mapper.apply(value);
            RetryData data = this.retryRegistry.get(rootCauseClass);
            if (data == null) {
                data = this.createRetryData(action);
                this.retryRegistry.put(rootCauseClass, data);
            }
            return data;
        }

        private RetryData createRetryData(AdvancedAction action) {
            if (action == AdvancedAction.RETRY_DELAYED) {
                return new RetryData(0, this.minWaitMillis, this.maxWaitMillis);
            }
            return new RetryData(this.nrImmediateRetries, this.minWaitMillis, this.maxWaitMillis);
        }
    }

    private static final class RetryData {
        private int immediateLeft;
        private int p1;
        private int p2;
        private final int maxDelay;

        RetryData(int immediateLeft, int p1, int maxDelay) {
            this.immediateLeft = immediateLeft;
            if (p1 < 1) {
                this.p1 = 0;
                this.p2 = 1;
            } else {
                this.p1 = p1;
                this.p2 = p1;
            }
            this.maxDelay = maxDelay;
        }

        int nextDelay() {
            if (this.immediateLeft > 0) {
                --this.immediateLeft;
                return 0;
            }
            if (this.p2 > this.maxDelay) {
                return this.maxDelay;
            }
            int result = this.p2;
            this.p2 = this.p1 + this.p2;
            this.p1 = result;
            return result;
        }
    }
}

