/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.io.IOException;
import java.nio.CharBuffer;
import org.spf4j.base.Arrays;
import org.spf4j.base.Strings;

public final class Base64 {
    private static final byte[] DECODE_MAP = Base64.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] ENCODE_MAP = Base64.initEncodeMap();

    private Base64() {
    }

    private static byte[] initDecodeMap() {
        int i;
        byte[] map = new byte[128];
        for (i = 0; i < 128; ++i) {
            map[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            map[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map[i] = (byte)(i - 48 + 52);
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    private static int guessLength(CharSequence text, int from, int len) {
        int padSize;
        int j;
        int to = from + len;
        for (j = to - 1; j >= 0; --j) {
            byte code = DECODE_MAP[text.charAt(j)];
            if (code == 127) continue;
            if (code != -1) break;
            return len / 4 * 3;
        }
        if ((padSize = to - ++j) > 2) {
            return len / 4 * 3;
        }
        return len / 4 * 3 - padSize;
    }

    private static int guessLength(char[] text, int from, int len) {
        int padSize;
        int j;
        int to = from + len;
        for (j = to - 1; j >= 0; --j) {
            byte code = DECODE_MAP[text[j]];
            if (code == 127) continue;
            if (code != -1) break;
            return len / 4 * 3;
        }
        if ((padSize = to - ++j) > 2) {
            return len / 4 * 3;
        }
        return len / 4 * 3 - padSize;
    }

    public static byte[] decodeBase64(CharSequence text) {
        return Base64.decodeBase64(text, 0, text.length());
    }

    public static byte[] decodeBase64(String text) {
        return Base64.decodeBase64(text, 0, text.length());
    }

    public static byte[] decodeBase64(String text, int from, int length) {
        return Base64.decodeBase64((CharSequence)text, from, length);
    }

    public static byte[] decodeBase64V2(String text, int from, int length) {
        char[] steal = Strings.steal(text);
        return Base64.decodeBase64(steal, from, length);
    }

    public static byte[] decodeBase64(CharSequence text, int from, int len) {
        int buflen = Base64.guessLength(text, from, len);
        byte[] out = new byte[buflen];
        int o = 0;
        byte[] quadruplet = new byte[4];
        int q = 0;
        int to = from + len;
        for (int i = from; i < to; ++i) {
            char ch = text.charAt(i);
            byte v = DECODE_MAP[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }

    public static byte[] decodeBase64(char[] text, int from, int len) {
        int buflen = Base64.guessLength(text, from, len);
        byte[] out = new byte[buflen];
        int o = 0;
        byte[] quadruplet = new byte[4];
        int q = 0;
        int to = from + len;
        for (int i = from; i < to; ++i) {
            char ch = text[i];
            byte v = DECODE_MAP[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map = new char[64];
        for (i = 0; i < 26; ++i) {
            map[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map[i] = (char)(48 + (i - 52));
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    public static char encode(int i) {
        return ENCODE_MAP[i & 0x3F];
    }

    public static byte encodeByte(int i) {
        return (byte)ENCODE_MAP[i & 0x3F];
    }

    public static String encodeBase64(byte[] input) {
        return Base64.encodeBase64(input, 0, input.length);
    }

    public static String encodeBase64(byte[] input, int offset, int len) {
        char[] buf = Arrays.getCharsTmp((len + 2) / 3 * 4);
        int ptr = Base64.encodeBase64(input, offset, len, buf, 0);
        return new String(buf, 0, ptr);
    }

    public static CharSequence encodeBase64V2(byte[] input, int offset, int len) {
        char[] buf = new char[(len + 2) / 3 * 4];
        int ptr = Base64.encodeBase64(input, offset, len, buf, 0);
        assert (ptr == buf.length);
        return CharBuffer.wrap(buf);
    }

    public static void encodeBase64(byte[] input, int offset, int len, Appendable result) throws IOException {
        block4: for (int i = offset; i < len; i += 3) {
            switch (len - i) {
                case 1: {
                    result.append(Base64.encode(input[i] >> 2));
                    result.append(Base64.encode((input[i] & 3) << 4));
                    result.append("==");
                    continue block4;
                }
                case 2: {
                    result.append(Base64.encode(input[i] >> 2));
                    result.append(Base64.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
                    result.append(Base64.encode((input[i + 1] & 0xF) << 2));
                    result.append('=');
                    continue block4;
                }
                default: {
                    result.append(Base64.encode(input[i] >> 2));
                    result.append(Base64.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF));
                    result.append(Base64.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3));
                    result.append(Base64.encode(input[i + 2] & 0x3F));
                }
            }
        }
    }

    public static int encodeBase64(byte[] input, int offset, int len, char[] output, int cptr) {
        int ptr = cptr;
        block4: for (int i = offset; i < len; i += 3) {
            switch (len - i) {
                case 1: {
                    output[ptr++] = Base64.encode(input[i] >> 2);
                    output[ptr++] = Base64.encode((input[i] & 3) << 4);
                    output[ptr++] = 61;
                    output[ptr++] = 61;
                    continue block4;
                }
                case 2: {
                    output[ptr++] = Base64.encode(input[i] >> 2);
                    output[ptr++] = Base64.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    output[ptr++] = Base64.encode((input[i + 1] & 0xF) << 2);
                    output[ptr++] = 61;
                    continue block4;
                }
                default: {
                    output[ptr++] = Base64.encode(input[i] >> 2);
                    output[ptr++] = Base64.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    output[ptr++] = Base64.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
                    output[ptr++] = Base64.encode(input[i + 2] & 0x3F);
                }
            }
        }
        return ptr;
    }

    public static int encodeBase64(byte[] input, int offset, int len, byte[] out, int cptr) {
        int ptr = cptr;
        byte[] buf = out;
        int max = len + offset;
        block4: for (int i = offset; i < max; i += 3) {
            switch (max - i) {
                case 1: {
                    buf[ptr++] = Base64.encodeByte(input[i] >> 2);
                    buf[ptr++] = Base64.encodeByte((input[i] & 3) << 4);
                    buf[ptr++] = 61;
                    buf[ptr++] = 61;
                    continue block4;
                }
                case 2: {
                    buf[ptr++] = Base64.encodeByte(input[i] >> 2);
                    buf[ptr++] = Base64.encodeByte((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    buf[ptr++] = Base64.encodeByte((input[i + 1] & 0xF) << 2);
                    buf[ptr++] = 61;
                    continue block4;
                }
                default: {
                    buf[ptr++] = Base64.encodeByte(input[i] >> 2);
                    buf[ptr++] = Base64.encodeByte((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    buf[ptr++] = Base64.encodeByte((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
                    buf[ptr++] = Base64.encodeByte(input[i + 2] & 0x3F);
                }
            }
        }
        return ptr;
    }
}

