/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.OriginsSheetV0d9d4;
import org.spdx.spdxspreadsheet.OriginsSheetV1d1;
import org.spdx.spdxspreadsheet.OriginsSheetV1d2;
import org.spdx.spdxspreadsheet.OriginsSheetV2d0;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public abstract class DocumentInfoSheet
extends AbstractSheet {
    static final int SPREADSHEET_VERSION_COL = 0;
    static final int DATA_ROW_NUM = 1;
    protected String version;

    public DocumentInfoSheet(Workbook workbook, String sheetName, String version) {
        super(workbook, sheetName);
        this.version = version;
    }

    public static void create(Workbook wb, String sheetName) {
        OriginsSheetV2d0.create(wb, sheetName);
    }

    public static DocumentInfoSheet openVersion(Workbook workbook, String originSheetName, String version) {
        if (version.compareTo("0.9.4") <= 0) {
            return new OriginsSheetV0d9d4(workbook, originSheetName, version);
        }
        if (version.compareToIgnoreCase("1.1.0") <= 0) {
            return new OriginsSheetV1d1(workbook, originSheetName, version);
        }
        if (version.compareToIgnoreCase("1.2.0") <= 0) {
            return new OriginsSheetV1d2(workbook, originSheetName, version);
        }
        return new OriginsSheetV2d0(workbook, originSheetName, version);
    }

    protected Row getDataRow() {
        return this.getDataRow(0);
    }

    protected Row getDataRow(int rowIndex) {
        while (this.firstRowNum + 1 + rowIndex > this.lastRowNum) {
            this.addRow();
        }
        Row dataRow = this.sheet.getRow(this.firstRowNum + 1 + rowIndex);
        if (dataRow == null) {
            dataRow = this.sheet.createRow(this.firstRowNum + 1 + rowIndex);
        }
        return dataRow;
    }

    protected Cell getOrCreateDataCell(int colNum) {
        Cell cell = this.getDataRow().getCell(colNum);
        if (cell == null) {
            cell = this.getDataRow().createCell(colNum);
            cell.setCellType(CellType.NUMERIC);
        }
        return cell;
    }

    protected void setDataCellStringValue(int colNum, String value) {
        this.getOrCreateDataCell(colNum).setCellValue(value);
    }

    protected void setDataCellDateValue(int colNum, Date value) {
        Cell cell = this.getOrCreateDataCell(colNum);
        cell.setCellValue(value);
        cell.setCellStyle(this.dateStyle);
    }

    protected Date getDataCellDateValue(int colNum) {
        Cell cell = this.getDataRow().getCell(colNum);
        if (cell == null) {
            return null;
        }
        return cell.getDateCellValue();
    }

    protected String getDataCellStringValue(int colNum) {
        Cell cell = this.getDataRow().getCell(colNum);
        if (cell == null) {
            return null;
        }
        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
            return Double.toString(cell.getNumericCellValue());
        }
        return cell.getStringCellValue();
    }

    public abstract void setSPDXVersion(String var1);

    public abstract void setCreatedBy(String[] var1);

    public abstract void setDataLicense(String var1);

    public abstract void setAuthorComments(String var1);

    public abstract void setCreated(Date var1);

    public abstract Date getCreated();

    public abstract String[] getCreatedBy();

    public abstract String getAuthorComments();

    public abstract String getSPDXVersion();

    public abstract String getDataLicense();

    public abstract String getDocumentComment();

    public abstract void setDocumentComment(String var1);

    public abstract String getLicenseListVersion();

    public abstract void setLicenseListVersion(String var1);

    public abstract String getNamespace();

    public abstract void addDocument(SpdxDocument var1) throws SpreadsheetException;

    public abstract String getSpdxId();

    public abstract void setSpdxId(String var1);

    public abstract String getDocumentName();

    public abstract void setDocumentName(String var1);

    public abstract String[] getDocumentContents();

    public abstract void setDocumentDescribes(String[] var1);

    public abstract ExternalDocumentRef[] getExternalDocumentRefs() throws SpreadsheetException;

    public abstract void setExternalDocumentRefs(ExternalDocumentRef[] var1) throws SpreadsheetException;
}

