/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model.pointer;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.SinglePointer;

public final class PointerFactory {
    public static SinglePointer getSinglePointerFromModel(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        if (!node.isURI() && !node.isBlank()) {
            throw new InvalidSPDXAnalysisException("Can not create a SinglePointer from a literal node");
        }
        if (node.isURI() && !node.getURI().startsWith(modelContainer.getDocumentNamespace())) {
            throw new InvalidSPDXAnalysisException("Unable to access SinglePointer snippet information outside of the SPDX document");
        }
        SinglePointer retval = PointerFactory.getElementByType(modelContainer, node);
        if (retval == null && (retval = PointerFactory.guessElementByProperties(modelContainer, node)) == null) {
            throw new InvalidSPDXAnalysisException("Unable to determine the SinglePointer type from the model");
        }
        return retval;
    }

    private static SinglePointer getElementByType(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = modelContainer.getModel().getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Triple m = Triple.createMatch((Node)node, (Node)rdfTypePredicate, null);
        ExtendedIterator tripleIter = modelContainer.getModel().getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple triple = (Triple)tripleIter.next();
            if (tripleIter.hasNext()) {
                throw new InvalidSPDXAnalysisException("More than one type associated with a SinglePointer");
            }
            Node typeNode = triple.getObject();
            if (!typeNode.isURI()) {
                throw new InvalidSPDXAnalysisException("Invalid type for a SinglePointer - not a URI");
            }
            String typeUri = typeNode.getURI();
            if (!typeUri.startsWith("http://www.w3.org/2009/pointers#")) {
                throw new InvalidSPDXAnalysisException("Invalid type for a SinglePointer - not an RDF Pointer type (namespace must begin with http://www.w3.org/2009/pointers#");
            }
            String type = typeUri.substring("http://www.w3.org/2009/pointers#".length());
            if (type.equals("ByteOffsetPointer")) {
                return new ByteOffsetPointer(modelContainer, node);
            }
            if (type.equals("LineCharPointer")) {
                return new LineCharPointer(modelContainer, node);
            }
            throw new InvalidSPDXAnalysisException("Unsupported type for SinglePointer '" + type + "'");
        }
        return null;
    }

    private static SinglePointer guessElementByProperties(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        if (PointerFactory.propertyExists(modelContainer, node, "http://www.w3.org/2009/pointers#", "offset")) {
            return new ByteOffsetPointer(modelContainer, node);
        }
        if (PointerFactory.propertyExists(modelContainer, node, "http://www.w3.org/2009/pointers#", "lineNumber")) {
            return new LineCharPointer(modelContainer, node);
        }
        return null;
    }

    private static boolean propertyExists(IModelContainer modelContainer, Node node, String namespace, String propertyName) {
        Node p = modelContainer.getModel().getProperty(namespace, propertyName).asNode();
        Triple m = Triple.createMatch((Node)node, (Node)p, null);
        ExtendedIterator tripleIter = modelContainer.getModel().getGraph().find(m);
        return tripleIter.hasNext();
    }
}

