/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElementFactory;
import org.spdx.rdfparser.model.SpdxSnippet;

public class SpdxElement
extends RdfModelObject {
    static final Logger logger = LoggerFactory.getLogger(RdfModelObject.class);
    protected Annotation[] annotations;
    protected String comment;
    protected String name;
    protected Relationship[] relationships;
    private String id;

    public SpdxElement(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
        SpdxElementFactory.addToCreatedElements(modelContainer, node, this);
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        SpdxElementFactory.addToCreatedElements(this.modelContainer, this.node, this);
        this.annotations = this.findAnnotationPropertyValues("http://spdx.org/rdf/terms#", "annotation");
        this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        this.name = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", this.getNamePropertyName());
        this.relationships = this.findRelationshipPropertyValues("http://spdx.org/rdf/terms#", "relationship");
        this.id = null;
        if (this.resource.isURIResource()) {
            if (this.resource.getURI().startsWith(this.modelContainer.getDocumentNamespace())) {
                this.id = this.resource.getURI().substring(this.modelContainer.getDocumentNamespace().length());
            } else {
                String docId;
                String[] parts = this.resource.getURI().split("#");
                if (parts.length == 2 && (docId = this.modelContainer.documentNamespaceToId(parts[0])) != null) {
                    this.id = docId + ":" + parts[1];
                }
            }
        }
    }

    public SpdxElement(String name, String comment, Annotation[] annotations, Relationship[] relationships) {
        this.name = name;
        this.comment = comment;
        this.annotations = annotations != null ? annotations : new Annotation[0];
        this.relationships = relationships != null ? relationships : new Relationship[0];
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        if (this.resource != null) {
            if (this.name != null) {
                this.setPropertyValue("http://spdx.org/rdf/terms#", this.getNamePropertyName(), this.name);
            }
            if (this.comment != null) {
                this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", this.comment);
            }
            if (this.annotations != null) {
                this.setPropertyValues("http://spdx.org/rdf/terms#", "annotation", this.annotations);
            }
            if (this.relationships != null) {
                this.setPropertyValues("http://spdx.org/rdf/terms#", "relationship", this.relationships);
            }
            SpdxElementFactory.addToCreatedElements(this.modelContainer, this.node, this);
        }
    }

    @Override
    public List<String> verify() {
        String localName = this.name;
        ArrayList retval = Lists.newArrayList();
        if (this.name == null) {
            if (!(this instanceof SpdxSnippet)) {
                retval.add("Missing required name for type " + this.getClass().getName());
            }
            localName = "UNKNOWN";
        }
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                List<String> annotationErrors = annotation.verify();
                for (String annotationError : annotationErrors) {
                    retval.add("Annotation error for SPDX element " + localName + ": " + annotationError);
                }
            }
        }
        return retval;
    }

    protected void addNameToWarnings(List<String> warnings) {
        if (warnings == null) {
            return;
        }
        String localName = this.name;
        if (localName == null) {
            localName = "[UNKNOWN]";
        }
        for (int i = 0; i < warnings.size(); ++i) {
            warnings.set(i, warnings.get(i) + " in " + localName);
        }
    }

    public Annotation[] getAnnotations() {
        if (this.model != null && this.refreshOnGet) {
            try {
                IRdfModel[] refresh = this.findAnnotationPropertyValues("http://spdx.org/rdf/terms#", "annotation");
                if (refresh == null || !this.arraysEquivalent(refresh, this.annotations, true)) {
                    this.annotations = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid annotations in the model", (Throwable)e);
            }
        }
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) throws InvalidSPDXAnalysisException {
        this.annotations = annotations == null ? new Annotation[0] : annotations;
        this.setPropertyValues("http://spdx.org/rdf/terms#", "annotation", annotations);
    }

    public String getComment() {
        if (this.resource != null && this.refreshOnGet) {
            this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", comment);
    }

    public String getName() {
        if (this.resource != null && this.refreshOnGet) {
            this.name = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", this.getNamePropertyName());
        }
        return this.name;
    }

    protected String getNamePropertyName() {
        return "name";
    }

    public void setName(String name) {
        this.name = name;
        this.setPropertyValue("http://spdx.org/rdf/terms#", this.getNamePropertyName(), name);
    }

    public Relationship[] getRelationships() {
        if (this.model != null && this.refreshOnGet) {
            try {
                IRdfModel[] refresh = this.findRelationshipPropertyValues("http://spdx.org/rdf/terms#", "relationship");
                if (refresh != null && !this.arraysEquivalent(refresh, this.relationships, true)) {
                    this.relationships = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Invalid relationships in the model", (Throwable)e);
            }
        }
        return this.relationships;
    }

    public void setRelationships(Relationship[] relationships) throws InvalidSPDXAnalysisException {
        this.relationships = relationships == null ? new Relationship[0] : relationships;
        this.setPropertyValues("http://spdx.org/rdf/terms#", "relationship", relationships);
    }

    public String getId() {
        if (this.resource != null && this.resource.isURIResource() && this.resource.getURI().startsWith(this.modelContainer.getDocumentNamespace())) {
            this.id = this.resource.getURI().substring(this.modelContainer.getDocumentNamespace().length());
        }
        if (this.id == null) {
            return String.valueOf(this.hashCode());
        }
        return this.id;
    }

    public void setId(String id) throws InvalidSPDXAnalysisException {
        if (this.modelContainer != null && this.resource != null) {
            throw new InvalidSPDXAnalysisException("Can not set a file ID for an SPDX element already in an RDF Model. You must create a new SPDX File with this ID.");
        }
        this.id = id;
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        if (this.node != null && this.node.isURI()) {
            return this.node.getURI();
        }
        if (this.id == null || this.id.isEmpty()) {
            this.id = modelContainer.getNextSpdxElementRef();
        } else {
            if (modelContainer.spdxElementRefExists(this.id)) {
                throw new InvalidSPDXAnalysisException("Duplicate ID: " + this.id);
            }
            modelContainer.addSpdxElementRef(this.id);
        }
        return modelContainer.getDocumentNamespace() + this.id;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#SpdxElement");
    }

    protected Annotation[] cloneAnnotations() {
        if (this.annotations == null) {
            return null;
        }
        Annotation[] clonedAnnotations = new Annotation[this.annotations.length];
        for (int i = 0; i < this.annotations.length; ++i) {
            clonedAnnotations[i] = this.annotations[i].clone();
        }
        return clonedAnnotations;
    }

    protected Relationship[] cloneRelationships(Map<String, SpdxElement> clonedElementIds) {
        if (this.relationships == null) {
            return null;
        }
        Relationship[] clonedRelationships = new Relationship[this.relationships.length];
        for (int i = 0; i < this.relationships.length; ++i) {
            clonedRelationships[i] = this.relationships[i].clone(clonedElementIds);
        }
        return clonedRelationships;
    }

    public SpdxElement clone() {
        return this.clone(Maps.newHashMap());
    }

    public SpdxElement clone(Map<String, SpdxElement> clonedElementIds) {
        if (clonedElementIds.containsKey(this.getId())) {
            return clonedElementIds.get(this.getId());
        }
        SpdxElement retval = new SpdxElement(this.name, this.comment, this.cloneAnnotations(), null);
        clonedElementIds.put(this.getId(), retval);
        try {
            retval.setRelationships(this.cloneRelationships(clonedElementIds));
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Unexected error setting relationships during clone", (Throwable)e);
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpdxElement)) {
            return false;
        }
        SpdxElement comp = (SpdxElement)o;
        if (testRelationships && !this.arraysEquivalent(comp.getRelationships(), this.getRelationships(), false)) {
            return false;
        }
        return Objects.equal((Object)comp.getName(), (Object)this.getName()) && this.arraysEquivalent(comp.getAnnotations(), this.getAnnotations(), testRelationships) && RdfModelHelper.stringsEquivalent(comp.getComment(), this.getComment());
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public void addRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        if (relationship != null) {
            this.relationships = Arrays.copyOf(this.relationships, this.relationships.length + 1);
            this.relationships[this.relationships.length - 1] = relationship;
            this.addPropertyValue("http://spdx.org/rdf/terms#", "relationship", relationship);
        }
    }

    public void addAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        if (annotation != null) {
            this.annotations = Arrays.copyOf(this.annotations, this.annotations.length + 1);
            this.annotations[this.annotations.length - 1] = annotation;
            this.addPropertyValue("http://spdx.org/rdf/terms#", "annotation", annotation);
        }
    }

    @Override
    public boolean arraysEquivalent(IRdfModel[] array1, IRdfModel[] array2) {
        return this.arraysEquivalent(array1, array2, true);
    }

    public boolean arraysEquivalent(IRdfModel[] array1, IRdfModel[] array2, boolean testRelationships) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        HashSet foundIndexes = Sets.newHashSet();
        for (int i = 0; i < array1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < array2.length; ++j) {
                if (foundIndexes.contains(j)) continue;
                if (array1[i] instanceof SpdxElement && array2[j] instanceof SpdxElement) {
                    if (!this.equivalentConsideringNull((SpdxElement)array1[i], (SpdxElement)array2[j], testRelationships)) continue;
                    found = true;
                    foundIndexes.add(j);
                    break;
                }
                if (!this.equivalentConsideringNull(array1[i], array2[j])) continue;
                found = true;
                foundIndexes.add(j);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equivalentConsideringNull(IRdfModel o1, IRdfModel o2) {
        if (o1 instanceof SpdxElement && o2 instanceof SpdxElement) {
            return this.equivalentConsideringNull((SpdxElement)o1, (SpdxElement)o2, true);
        }
        return super.equivalentConsideringNull(o1, o2);
    }

    public boolean equivalentConsideringNull(SpdxElement o1, SpdxElement o2, boolean testRelationship) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equivalent(o2, testRelationship);
    }
}

