/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.base.Objects;
import java.util.Arrays;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.License;
import org.spdx.rdfparser.model.IRdfModel;

public abstract class SimpleLicensingInfo
extends AnyLicenseInfo {
    protected String licenseId;
    protected String comment;
    protected String name;
    protected String[] seeAlso;

    SimpleLicensingInfo(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.licenseId = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseId");
        this.name = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "name");
        if (this.name == null) {
            this.name = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseName");
        }
        this.seeAlso = this.findMultiplePropertyValues("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
        String[] moreSeeAlso = this.findMultiplePropertyValues("http://spdx.org/rdf/terms#", "licenseSourceUrl");
        if (moreSeeAlso != null && moreSeeAlso.length > 0) {
            int startExtraIndex = this.seeAlso.length;
            this.seeAlso = Arrays.copyOf(this.seeAlso, startExtraIndex + moreSeeAlso.length);
            for (int i = 0; i < moreSeeAlso.length; ++i) {
                this.seeAlso[startExtraIndex + i] = moreSeeAlso[i];
            }
        }
        this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        if (this.comment == null) {
            this.comment = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseNotes");
        }
    }

    SimpleLicensingInfo(String name, String id, String comments, String[] sourceUrl) {
        this.licenseId = id;
        this.name = name;
        this.comment = comments;
        this.seeAlso = sourceUrl;
    }

    public String getLicenseId() {
        if (this.resource != null && this.refreshOnGet) {
            this.licenseId = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseId");
        }
        return this.licenseId;
    }

    public void setLicenseId(String id) {
        this.licenseId = id;
        if (id == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseId");
        } else {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseId", id);
        }
    }

    public String getName() {
        if (this.resource != null && this.refreshOnGet) {
            this.name = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "name");
            if (this.name == null) {
                this.name = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseName");
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.node != null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseName");
            if (name == null) {
                this.removePropertyValue("http://spdx.org/rdf/terms#", "name");
            } else {
                this.setPropertyValue("http://spdx.org/rdf/terms#", "name", name);
            }
        }
    }

    public String getComment() {
        if (this.resource != null && this.refreshOnGet) {
            this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
            if (this.comment == null) {
                this.comment = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "licenseNotes");
            }
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.node != null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseNotes");
            if (comment == null) {
                this.removePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
            } else {
                this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", comment);
            }
        }
    }

    public String[] getSeeAlso() {
        if (this.resource != null && this.refreshOnGet) {
            this.seeAlso = this.findMultiplePropertyValues("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            String[] moreSeeAlso = this.findMultiplePropertyValues("http://spdx.org/rdf/terms#", "licenseSourceUrl");
            if (moreSeeAlso != null && moreSeeAlso.length > 0) {
                int startExtraIndex = this.seeAlso.length;
                this.seeAlso = Arrays.copyOf(this.seeAlso, startExtraIndex + moreSeeAlso.length);
                for (int i = 0; i < moreSeeAlso.length; ++i) {
                    this.seeAlso[startExtraIndex + i] = moreSeeAlso[i];
                }
            }
        }
        return this.seeAlso;
    }

    public void setSeeAlso(String[] seeAlsoUrl) {
        this.seeAlso = seeAlsoUrl;
        if (this.node != null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseSourceUrl");
            if (this.seeAlso == null) {
                this.removePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            } else {
                this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "seeAlso", this.seeAlso);
            }
        }
    }

    @Override
    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        Property idProperty = modelContainer.getModel().createProperty("http://spdx.org/rdf/terms#", "licenseId");
        Property typeProperty = modelContainer.getModel().getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
        Triple m = Triple.createMatch(null, (Node)idProperty.asNode(), null);
        ExtendedIterator tripleIter = modelContainer.getModel().getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (!t.getObject().toString(false).equals(this.licenseId)) continue;
            Triple typeMatch = Triple.createMatch((Node)t.getSubject(), (Node)typeProperty.asNode(), (Node)this.getType(modelContainer.getModel()).asNode());
            ExtendedIterator typeTripleIter = modelContainer.getModel().getGraph().find(typeMatch);
            if (!typeTripleIter.hasNext()) continue;
            if (t.getSubject().isURI()) {
                return modelContainer.getModel().createResource(t.getSubject().getURI());
            }
            if (!t.getSubject().isBlank()) continue;
            return modelContainer.getModel().createResource(new AnonId(t.getSubject().getBlankNodeId()));
        }
        return null;
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        if (this.licenseId == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "licenseId");
        } else {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseId", this.licenseId);
        }
        if (this.comment == null) {
            this.removePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        } else {
            this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", this.comment);
        }
        if (this.name == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "name");
        } else {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "name", this.name);
        }
        if (this.seeAlso == null) {
            this.removePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
        } else {
            this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "seeAlso", this.seeAlso);
        }
    }

    @Override
    public int hashCode() {
        if (this.getLicenseId() == null) {
            return 0;
        }
        return this.getLicenseId().hashCode();
    }

    @Override
    public boolean equals(Object comp) {
        if (comp == this) {
            return true;
        }
        if (!(comp instanceof License)) {
            return false;
        }
        License compl = (License)comp;
        return compl.getLicenseId().equals(this.getLicenseId());
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof SimpleLicensingInfo)) {
            return false;
        }
        SimpleLicensingInfo sCompare = (SimpleLicensingInfo)compare;
        return Objects.equal((Object)this.comment, (Object)sCompare.getComment()) && Objects.equal((Object)this.name, (Object)sCompare.getName()) && RdfModelHelper.arraysEqual(this.seeAlso, sCompare.getSeeAlso());
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        if (this.node != null && this.node.isURI()) {
            return this.node.getURI();
        }
        return modelContainer.getDocumentNamespace() + this.licenseId;
    }
}

