/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.LicenseException;

public class ExceptionTOCJSONFile
extends AbstractJsonFile {
    public static final String JSON_REFERENCE_FIELD = "detailsUrl";
    List<ListedSpdxException> listedExceptions = Lists.newArrayList();
    private int currentRefNumber = 1;
    String version;
    String releaseDate;

    public ExceptionTOCJSONFile(String version, String releaseDate) {
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public void addException(LicenseException exception, String excHTMLReference, String excJSONReference, boolean deprecated) {
        this.listedExceptions.add(new ListedSpdxException(excHTMLReference, String.valueOf(this.currentRefNumber), exception.getLicenseExceptionId(), exception.getName(), exception.getSeeAlso(), deprecated, this.relativeToAbsolute(excJSONReference)));
        ++this.currentRefNumber;
    }

    private String relativeToAbsolute(String relativeRef) {
        String retval = relativeRef.startsWith("./") ? relativeRef.substring(2) : relativeRef;
        retval = "http://spdx.org/licenses/" + retval;
        return retval;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"licenseListVersion", (Object)this.version);
        jsonObject.put((Object)"releaseDate", (Object)this.releaseDate);
        JSONArray exceptionList = new JSONArray();
        for (ListedSpdxException exception : this.listedExceptions) {
            JSONObject exceptionJSON = new JSONObject();
            exceptionJSON.put((Object)"reference", (Object)exception.getReference());
            exceptionJSON.put((Object)"referenceNumber", (Object)exception.getRefNumber());
            exceptionJSON.put((Object)"licenseExceptionId", (Object)exception.getExceptionId());
            exceptionJSON.put((Object)"name", (Object)exception.getName());
            String[] seeAlsos = exception.getSeeAlso();
            if (seeAlsos != null && seeAlsos.length > 0) {
                JSONArray seeAlsoArray = new JSONArray();
                for (String seeAlso : seeAlsos) {
                    seeAlsoArray.add((Object)seeAlso);
                }
                exceptionJSON.put((Object)"seeAlso", (Object)seeAlsoArray);
            }
            exceptionJSON.put((Object)"isDeprecatedLicenseId", (Object)exception.isDeprecated());
            exceptionJSON.put((Object)JSON_REFERENCE_FIELD, (Object)exception.getExcJSONReference());
            exceptionList.add((Object)exceptionJSON);
        }
        jsonObject.put((Object)"exceptions", (Object)exceptionList);
        return jsonObject;
    }

    private static class ListedSpdxException {
        private final String reference;
        private final String refNumber;
        private final String exceptionId;
        private final String name;
        private final String[] seeAlso;
        private boolean deprecated;
        private String excJSONReference;

        public ListedSpdxException(String reference, String refNumber, String exceptionId, String name, String[] seeAlso, boolean deprecated, String excJSONReference) {
            this.reference = reference;
            this.refNumber = refNumber;
            this.exceptionId = exceptionId;
            this.name = name;
            this.seeAlso = seeAlso;
            this.deprecated = deprecated;
            this.excJSONReference = excJSONReference;
        }

        public String getExcJSONReference() {
            return this.excJSONReference;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public String getReference() {
            return this.reference;
        }

        public String getRefNumber() {
            return this.refNumber;
        }

        public String getExceptionId() {
            return this.exceptionId;
        }

        public String getName() {
            return this.name;
        }

        public String[] getSeeAlso() {
            return this.seeAlso;
        }
    }
}

