/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.spdxspreadsheet.AbstractSheet;

public class ReviewerSheet
extends AbstractSheet {
    private ReviewerComparator reviewerComparator = new ReviewerComparator();
    static final int COL_WIDTH = 40;

    public ReviewerSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < 25; ++i) {
            sheet.setColumnWidth(i, 10240);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importCompareResults(SpdxComparer comparer, String[] docNames) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (comparer.getNumSpdxDocs() != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        for (int i = 0; i < comparer.getNumSpdxDocs(); ++i) {
            Cell headerCell = header.getCell(i);
            headerCell.setCellValue(docNames[i]);
            SPDXReview[] reviewers = comparer.getSpdxDoc(i).getReviewers();
            if (reviewers == null) continue;
            StringBuilder sb = new StringBuilder();
            Arrays.sort(reviewers, this.reviewerComparator);
            for (int j = 0; j < reviewers.length; ++j) {
                Cell reviewerCell = null;
                while (j + 1 > this.getNumDataRows()) {
                    this.addRow();
                }
                reviewerCell = this.sheet.getRow(j + 1).createCell(i);
                sb.setLength(0);
                sb.append(reviewers[j].getReviewer());
                sb.append("[");
                sb.append(reviewers[j].getReviewDate());
                sb.append("]");
                if (reviewers[j].getComment() != null && !reviewers[j].getComment().isEmpty()) {
                    sb.append(" (");
                    sb.append(reviewers[j].getComment());
                    sb.append(")");
                }
                reviewerCell.setCellValue(sb.toString());
            }
        }
    }

    private static final class ReviewerComparator
    implements Comparator<SPDXReview>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ReviewerComparator() {
        }

        @Override
        public int compare(SPDXReview o1, SPDXReview o2) {
            int retval = o1.getReviewer().compareTo(o2.getReviewer());
            if (retval == 0) {
                retval = o1.getReviewDate().compareTo(o2.getReviewDate());
            }
            if (retval == 0) {
                retval = o1.getComment().compareTo(o2.getComment());
            }
            return retval;
        }
    }
}

